﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_Result.h>
#include "visrv_LcdDisplay.h"
#include "visrv_Nvdc.h"

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    LcdDisplay::LcdDisplay(const IModeFilter* pFilter) NN_NOEXCEPT
        : AndroidDisplay(pFilter, android::ISurfaceComposer::eDisplayIdMain, nn::vi::LayerStack_Default)
    {
    }

    nn::Result LcdDisplay::GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pOutState);
        NN_RESULT_DO(nvdc::GetConnectionState(pOutState, NVDC_DSI));
        NN_RESULT_SUCCESS;
    }

    nn::Result LcdDisplay::SetUnderscan(int underscan) NN_NOEXCEPT
    {
        NN_UNUSED(underscan);

        return nn::vi::ResultNotSupported();
    }

    nn::Result LcdDisplay::GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT
    {
        *pOutUnderscan = 0;

        return nn::ResultSuccess();
    }

    bool LcdDisplay::IsHotplugEventSupported() const NN_NOEXCEPT
    {
        return false;
    }

    bool LcdDisplay::IsVsyncEventSupported() const NN_NOEXCEPT
    {
        return true;
    }

    bool LcdDisplay::IsModeChangedEventSupported() const NN_NOEXCEPT
    {
        return false;
    }

    int LcdDisplay::ListRgbRanges(nn::vi::RgbRangeType* pOutRanges, int rgbCountMax) const NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pOutRanges);
        NN_SDK_ASSERT_GREATER(rgbCountMax, 0);

        if( GetRgbRange(pOutRanges).IsSuccess() )
        {
            return 1;
        }

        return 0;
    }

    nn::Result LcdDisplay::SetRgbRange(nn::vi::RgbRange range) NN_NOEXCEPT
    {
        if( range == nn::vi::RgbRange_Auto )
        {
            range = nn::vi::RgbRange_Full;
        }

        if( range != nn::vi::RgbRange_Full )
        {
            return nn::vi::ResultNotSupported();
        }

        if( android::SurfaceComposerClient::setRGBRange(m_Display, ConvertRgbRangeToAndroid(range)) == 0 )
        {
            return nn::ResultSuccess();
        }

        return nn::vi::ResultOperationFailed();
    }

}}}}
