﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

namespace nn { namespace visrv { namespace master { namespace detail {

    class IPhysicalDisplay;

    // Determines how to route requests to displays for multi-display scenarios
    class IDisplayStrategy
    {
    public:
        virtual ~IDisplayStrategy() NN_NOEXCEPT;

        virtual IPhysicalDisplay* GetDisplay() NN_NOEXCEPT = 0;

        typedef nn::Result (*DisplayVisitor)(IPhysicalDisplay*, void*);
        virtual nn::Result Visit(DisplayVisitor visitor, void* userData) NN_NOEXCEPT = 0;
    };

}}}}
