﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    class Autolock
    {
    NN_DISALLOW_COPY(Autolock);
    public:
        /**
         * @brief Locks the mutex.
         *
         * @param[in] lock Mutex to automatically lock/unlock.
         */
        explicit Autolock(nn::os::Mutex* pLock) NN_NOEXCEPT;
        Autolock(Autolock&& copy) NN_NOEXCEPT;

        /**
         * @brief Unlocks the mutex.
         */
        ~Autolock() NN_NOEXCEPT;
    private:
        nn::os::Mutex* m_pLock; //!< Mutex to automatically lock/unlock.
    };

}}}}
