﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include "visrv_ILocalLayer.h"

namespace nn{ namespace visrv{ namespace client{
    class ClientObject;
}}}

namespace nn{ namespace visrv{ namespace local{

    class LocalManagedLayer
        : public ILocalLayer
    {
    public:
        LocalManagedLayer() NN_NOEXCEPT;

        // 初期化。指定したレイヤをバインドする。
        nn::Result Initialize(
            client::ClientObject* pClient,
            nn::vi::LayerId layerId,
            const char* displayName,
            nn::applet::AppletResourceUserId aruid
            ) NN_NOEXCEPT;
        // 破棄。レイヤをアンバインドする。
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;
        nn::vi::LayerId GetLayerId() const NN_NOEXCEPT;

        virtual uint64_t   GetLayerResourceId() const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result Connect() NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result Disconnect() NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetBufferCount(int count) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetBuffer(int index, const android::sp<android::GraphicBuffer>& pBuffer) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result RequestBuffer(int index) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result Present(int index, const android::sp<android::Fence>& fence, const nn::vi::CropRegion& crop, int scalingMode, nn::vi::ImageTransformType transform, int presentInterval) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result Acquire(int* pOutIndex, android::sp<android::Fence>* pOutFence, int expectedWidth, int expectedHeight) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetAcquirableEvent(nn::os::SystemEventType* pOutValue) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetLayerStackFlags(nn::vi::LayerStackFlagType stacks) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetLayerStackFlags(nn::vi::LayerStackFlagType* pOutStacks) NN_NOEXCEPT NN_OVERRIDE;

    private:
        client::ClientObject* m_pClientObject;
        nn::vi::LayerId       m_LayerId;
        uint32_t m_BinderHandle;
    };

}}}
