﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_IndirectNative.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_StringUtil.h>
#include <nn/vi/vi_Result.h>

#include <binder/Parcel.h>


namespace nn{ namespace visrv{ namespace indirect{

    nn::Result SerializeIndirectProducer(
        size_t* pOutSize,
        void* buffer,
        size_t bufferSize,
        const android::sp<android::IBinder>& pBinder,
        const char* serviceName,
        uint32_t binderHandle
        ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOutSize);
        NN_SDK_REQUIRES(pBinder != nullptr);
        NN_SDK_REQUIRES_NOT_NULL(serviceName);

        char* pBuffer = reinterpret_cast<char*>(buffer);
        android::Parcel parcel;

        // write binder to parcel
        NN_RESULT_THROW_UNLESS(parcel.writeStrongBinder(pBinder) == android::NO_ERROR, nn::vi::ResultOperationFailed());
        NN_RESULT_THROW_UNLESS(parcel.errorCheck() == android::NO_ERROR, nn::vi::ResultOperationFailed());

        // write parcel to buffer
        size_t headSize = sizeof(hosbinder_transaction_t);
        size_t dataSize = parcel.ipcDataSize();
        size_t objSize  = parcel.ipcObjectsCount() * sizeof(binder_size_t);
        size_t requiredSize = headSize + dataSize + objSize;
        NN_RESULT_THROW_UNLESS(bufferSize >= requiredSize, nn::vi::ResultOperationFailed());

        hosbinder_transaction_t* tr = reinterpret_cast<hosbinder_transaction_t*>(buffer);
        memset(tr, 0, headSize);
        tr->data_size   = dataSize;
        tr->data_offset = headSize;
        tr->obj_size    = objSize;
        tr->obj_offset  = headSize + dataSize;
        memcpy(pBuffer + tr->data_offset, reinterpret_cast<void*>(parcel.ipcData())   , tr->data_size);
        memcpy(pBuffer + tr->obj_offset , reinterpret_cast<void*>(parcel.ipcObjects()), tr->obj_size );

        // replace binder to handle
        size_t numObj = parcel.ipcObjectsCount();
        binder_size_t* objs = reinterpret_cast<binder_size_t*>(pBuffer + tr->obj_offset);
        for(size_t i = 0; i < numObj; i++)
        {
            auto flat = reinterpret_cast<flat_binder_object*>(pBuffer + tr->data_offset + objs[i]);
            if(flat->type == BINDER_TYPE_BINDER)
            {
                flat->type   = BINDER_TYPE_HANDLE;
                flat->binder = 0;
                flat->handle = binderHandle;
                flat->cookie = 0;
                memset(flat->service_name, 0, sizeof(flat->service_name));
                nn::util::Strlcpy(flat->service_name, serviceName, sizeof(flat->service_name));
            }
            else if(flat->type == BINDER_TYPE_WEAK_BINDER)
            {
                NN_RESULT_THROW(nn::vi::ResultOperationFailed());
            }
        }

        *pOutSize = requiredSize;
        NN_RESULT_SUCCESS;
    }

}}}
