﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_Device.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace nn{ namespace visrv{ namespace fbshare{

    Device::Device() NN_NOEXCEPT
        : m_hDevice(0)
    {
    }

    void Device::Initialize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(m_hDevice == 0);
        NN_ABORT_UNLESS(NvSuccess == NvRmOpenNew(&m_hDevice));
    }

    void Device::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(m_hDevice != 0);
        NvRmClose(m_hDevice);
        m_hDevice = 0;
    }

    NvRmDeviceHandle Device::Get() const NN_NOEXCEPT
    {
        return m_hDevice;
    }

}}}
