﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "visrv_PresentationTracer.h"

namespace nn{ namespace visrv{
    class ServerManager;
}}

namespace nn{ namespace visrv{ namespace client{

    class PresentationTracerPool
    {
        friend class PresentationTracer;
        friend class detail::PresentationPreAcquireFenceWait;
    public:
        void Initialize(ServerManager* pServerManager, uintptr_t multiWaitTagBegin, uintptr_t multiWaitTagCount) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::Result Acquire(PresentationTracer** pOutTracer) NN_NOEXCEPT;
        void Release(PresentationTracer* pTracer) NN_NOEXCEPT;

        void ProcessMultiWaitSignal(nn::os::MultiWaitHolderType* pHolder, bool isUnlinked) NN_NOEXCEPT;

    private:
        void LinkMultiWaitImpl(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;
        void UnlinkMultiWaitImpl(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;

    private:
        util::TResourcePool<PresentationTracer, LayerPresentationTracerCountMax> m_Pool;

        ServerManager* m_pServerManager = nullptr;
        uintptr_t m_MultiWaitTagBegin = 0;
        uintptr_t m_MultiWaitTagCount = 0;
    };

    extern PresentationTracerPool g_PresentationTracerPool;

}}}
