﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_ClientObjectSmartHolder.h"

#include "visrv_ClientObject.h"
#include "../visrv_MemoryManagement.h"

namespace nn{ namespace visrv{ namespace client{

    ClientObjectSmartHolder::ClientObjectSmartHolder(const ClientConstants& clientConstants) NN_NOEXCEPT
    {
        m_pInstance = new(AllocateClientObject()) ClientObject(clientConstants);
        if(m_pInstance)
        {
            m_pInstance->Initialize();
            m_pInstance->m_ReferenceCount = 1;
            m_pInstance->m_IsAlive = true;
            m_IsStrong = true;
        }
    }

    ClientObjectSmartHolder::ClientObjectSmartHolder(ClientObjectSmartHolder* pHolder) NN_NOEXCEPT
    {
        m_pInstance = pHolder->m_pInstance;
        if(m_pInstance)
        {
            m_pInstance->m_ReferenceCount++;
            m_IsStrong = false;
        }
    }

    ClientObjectSmartHolder::~ClientObjectSmartHolder() NN_NOEXCEPT
    {
        if(m_pInstance)
        {
            m_pInstance->m_ReferenceCount--;

            if(m_IsStrong)
            {
                NN_SDK_ASSERT(m_pInstance->m_IsAlive);
                m_pInstance->Finalize();
                m_pInstance->m_IsAlive = false;
            }

            NN_SDK_ASSERT_GREATER_EQUAL(m_pInstance->m_ReferenceCount, 0);
            if(m_pInstance->m_ReferenceCount == 0)
            {
                m_pInstance->~ClientObject();
                FreeClientObject(m_pInstance);
            }
            m_pInstance = nullptr;
        }
    }

}}}
