﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <mutex>
#include <nn/util/util_TypedStorage.h>
#include <nn/vi/vi_Lib.h>
#include "detail/vi_Common.h"
#include "detail/vi_Globals.h"
#include "detail/vi_DisplayManager.h"
#include "detail/vi_PlatformDisplayDefines.h"
#include "detail/vi_PlatformDisplayInfo.h"
#include "detail/vi_Policies.h"
#include "detail/vi_MemoryMap.h"
#include "detail/vi_Lib.h"

void nn::vi::Initialize() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(detail::GetInitializerLock());

    if( !detail::IsInitialized() )
    {
        int platformDisplayCount = detail::SetupStandardPolicy(reinterpret_cast<detail::PlatformDisplayInfo*>(g_DisplayInfoSegment),
                                                               DisplayInfoSegmentSize / sizeof(detail::PlatformDisplayInfo));

        detail::g_DisplayManager = new (&g_DisplayManagerStorage) detail::DisplayManager(g_DisplaySegment,
                                                                                         DisplaySegmentSize,
                                                                                         g_LayerSegment,
                                                                                         LayerSegmentSize,
                                                                                         reinterpret_cast<detail::PlatformDisplayInfo*>(g_DisplayInfoSegment),
                                                                                         platformDisplayCount);

        detail::Initialize();
    }
}

void nn::vi::Finalize() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(detail::GetInitializerLock());

    if( detail::IsInitialized() )
    {
        detail::Finalize();

        detail::g_DisplayManager->~DisplayManager();
        detail::g_DisplayManager = nullptr;
    }
}
