﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_Display.private.h>
#include <nn/vi/vi_Result.h>
#include "vi_Display.h"
#include "detail/vi_Common.h"

int nn::vi::GetZOrderCountMin(const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->GetInfo().GetPolicy().GetZOrderCountMin();
}

int nn::vi::GetZOrderCountMax(const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->GetInfo().GetPolicy().GetZOrderCountMax();
}

nn::Result nn::vi::GetDisplayResolution(int* pOutWidth, int* pOutHeight, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutWidth);
    NN_SDK_REQUIRES_NOT_NULL(pOutHeight);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    nn::vi::DisplayModeInfo mode;

    if( pDisplay->GetMode(&mode).IsSuccess() )
    {
        *pOutWidth = static_cast<int>(mode.width);
        *pOutHeight = static_cast<int>(mode.height);

        return nn::ResultSuccess();
    }

    return nn::vi::ResultOperationFailed();
}
