﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_CmuLuma.h>
#include "detail/vi_Common.h"
#include "vi_Display.h"

nn::Result nn::vi::SetDisplayCmuLuma(Display* pDisplay, float luma) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->SetCmuLuma(luma);
}

nn::Result nn::vi::GetDisplayCmuLuma(float* pOutLuma, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutLuma);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->GetCmuLuma(pOutLuma);
}
