﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/vi/vi_Result.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include "vi_WindowsDisplay.h"
#include "../vi_Layer.h"

nn::Result nn::vi::detail::WindowsDisplay::Open() NN_NOEXCEPT
{
    return nn::ResultSuccess();
}

void nn::vi::detail::WindowsDisplay::Close() NN_NOEXCEPT
{
}

nn::Result nn::vi::detail::WindowsDisplay::GetHotplugState(HotplugState* pOutState) const NN_NOEXCEPT
{
    NN_UNUSED(pOutState);

    return nn::vi::ResultOperationFailed();
}

nn::Result nn::vi::detail::WindowsDisplay::GetMode(DisplayModeInfo* pOutMode) const NN_NOEXCEPT
{
    // functions that use this information are not supported on windows
    pOutMode->refreshRate = 0.f;
    pOutMode->mode = nn::vi::StereoMode_None;

    pOutMode->width  = 1280;
    pOutMode->height = 720;

    return nn::ResultSuccess();
}

int nn::vi::detail::WindowsDisplay::ListModes(DisplayModeInfo* pOutModes, int modeCountMax, const IModeFilter* pFilter) const NN_NOEXCEPT
{
    NN_UNUSED(pOutModes);
    NN_UNUSED(modeCountMax);
    NN_UNUSED(pFilter);

    return 0;
}

nn::Result nn::vi::detail::WindowsDisplay::SetMode(const DisplayModeInfo* pMode, const IModeFilter* pFilter) NN_NOEXCEPT
{
    NN_UNUSED(pMode);
    NN_UNUSED(pFilter);

    return nn::vi::ResultOperationFailed();
}

int nn::vi::detail::WindowsDisplay::ListRgbRanges(RgbRange* pOutRanges, int rgbCountMax) const NN_NOEXCEPT
{
    NN_UNUSED(pOutRanges);
    NN_UNUSED(rgbCountMax);

    return 0;
}

nn::Result nn::vi::detail::WindowsDisplay::GetRgbRange(RgbRange* pOutRange) const NN_NOEXCEPT
{
    NN_UNUSED(pOutRange);

    return nn::vi::ResultOperationFailed();
}

nn::Result nn::vi::detail::WindowsDisplay::SetRgbRange(RgbRange range) NN_NOEXCEPT
{
    NN_UNUSED(range);

    return nn::vi::ResultOperationFailed();
}

nn::Result nn::vi::detail::WindowsDisplay::SetUnderscan(int underscan) NN_NOEXCEPT
{
    NN_UNUSED(underscan);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::WindowsDisplay::GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT
{
    NN_UNUSED(pOutUnderscan);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::WindowsDisplay::SetAlpha(float alpha) NN_NOEXCEPT
{
    NN_UNUSED(alpha);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::WindowsDisplay::SetPowerState(PowerState state) NN_NOEXCEPT
{
    NN_UNUSED(state);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::WindowsDisplay::SetLayerStack(LayerStack id) NN_NOEXCEPT
{
    NN_UNUSED(id);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::WindowsDisplay::SetCmuLuma(float luma) NN_NOEXCEPT
{
    NN_UNUSED(luma);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::WindowsDisplay::GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT
{
    NN_UNUSED(pOutLuma);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::WindowsDisplay::GetHotplugEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT
{
    NN_UNUSED(pOutEvent);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::WindowsDisplay::GetVsyncEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutEvent);
    nn::os::NativeHandle handle = m_Vsync.GetClientReadableHandle();

    if( handle == nullptr )
    {
        return nn::vi::ResultDenied();
    }

    nn::os::AttachReadableHandleToSystemEvent(pOutEvent, handle, true, nn::os::EventClearMode_AutoClear);
    return nn::ResultSuccess();
}
