﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <nn/nn_Assert.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include <nn/vi/vi_DisplayMode.private.h>
#include "vi_Policies.h"
#include "vi_PlatformDisplayInfo.h"
#include "vi_PlatformDisplayDefines.h"

bool nn::vi::detail::PixelFormatSupport(nn::vi::PixelFormat format) NN_NOEXCEPT
{
    switch (format)
    {
    case nn::vi::PixelFormat_Rgba8888:
    case nn::vi::PixelFormat_Rgbx8888:
    case nn::vi::PixelFormat_StandardRgba8888:
    case nn::vi::PixelFormat_StandardRgbx8888:
        return true;
    default:
        return false;
    }
}

bool nn::vi::detail::ScalingModeSupport(nn::vi::ScalingMode mode) NN_NOEXCEPT
{
    switch (mode)
    {
    case nn::vi::ScalingMode_Exact:
    case nn::vi::ScalingMode_None:
    case nn::vi::ScalingMode_ScaleAndCrop:
        return false;
    default:
        return true;
    }
}
