﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_Result.h>
#include "vi_PhysicalDisplayAdapter.h"
#include "vi_WhitelistFilter.h"
#include "vi_IPhysicalDisplay.h"

nn::vi::detail::PhysicalDisplayAdapter::PhysicalDisplayAdapter(const detail::PlatformDisplayInfo& info, Display::Allocator* pAllocator, const IModeFilter* pFilter, IPhysicalDisplay* pExternal) NN_NOEXCEPT
    : Display(info, pAllocator, pFilter)
    , m_Display(pExternal)
{
}

nn::vi::detail::PhysicalDisplayAdapter::~PhysicalDisplayAdapter() NN_NOEXCEPT
{
    m_Display->Close();
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::Initialize() NN_NOEXCEPT
{
    if( m_Display->Open().IsFailure() )
    {
        return nn::vi::ResultOperationFailed();
    }

    return nn::ResultSuccess();
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::GetHotplugState(HotplugState* pOutState) const NN_NOEXCEPT
{
    return m_Display->GetHotplugState(pOutState);
}

int nn::vi::detail::PhysicalDisplayAdapter::ListModes(DisplayModeInfo* pOutModes, int modeCountMax, const IModeFilter* pFilter) const NN_NOEXCEPT
{
    return m_Display->ListModes(pOutModes, modeCountMax, pFilter);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::GetMode(DisplayModeInfo* pOutMode) const NN_NOEXCEPT
{
    return m_Display->GetMode(pOutMode);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::SetMode(const DisplayModeInfo* pMode, const IModeFilter* pFilter) NN_NOEXCEPT
{
    return m_Display->SetMode(pMode, pFilter);
}

int nn::vi::detail::PhysicalDisplayAdapter::ListRgbRanges(RgbRange* pOutRanges, int rgbRangeCountMax) const NN_NOEXCEPT
{
    return m_Display->ListRgbRanges(pOutRanges, rgbRangeCountMax);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::GetRgbRange(RgbRange* pOutRange) const NN_NOEXCEPT
{
    return m_Display->GetRgbRange(pOutRange);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::SetRgbRange(RgbRange range) NN_NOEXCEPT
{
    return m_Display->SetRgbRange(range);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::SetUnderscan(int underscan) NN_NOEXCEPT
{
    return m_Display->SetUnderscan(underscan);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT
{
    return m_Display->GetUnderscan(pOutUnderscan);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::SetAlpha(float alpha) NN_NOEXCEPT
{
    return m_Display->SetAlpha(alpha);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::SetPowerState(PowerState state) NN_NOEXCEPT
{
    return m_Display->SetPowerState(state);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::SetLayerStack(LayerStack id) NN_NOEXCEPT
{
    return m_Display->SetLayerStack(id);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::SetCmuLuma(float luma) NN_NOEXCEPT
{
    return m_Display->SetCmuLuma(luma);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT
{
    return m_Display->GetCmuLuma(pOutLuma);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::GetHotplugEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT
{
    return m_Display->GetHotplugEvent(pOutEvent);
}

nn::Result nn::vi::detail::PhysicalDisplayAdapter::GetVsyncEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT
{
    return m_Display->GetVsyncEvent(pOutEvent);
}
