﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <cstdlib>
#include "vi_Windows.h"
#include "vi_Lib.h"
#include "vi_PlatformDisplayDefines.h"
#include "vi_WindowManager.h"
#include "vi_Globals.h"
#include "vi_MemoryMap.h"

void nn::vi::detail::Initialize() NN_NOEXCEPT
{
    g_WindowManager = new (&g_WindowManagerStorage) WindowManager();
    g_WindowManager->Initialize();
}

void nn::vi::detail::Finalize() NN_NOEXCEPT
{
    g_WindowManager->Finalize();
    UnregisterClass(ApplicationClassName, GetModuleHandle(nullptr));
}
