﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_Result.h>
#include "vi_LcdDisplay.h"

nn::vi::detail::LcdDisplay::LcdDisplay() NN_NOEXCEPT
    : AndroidDisplay(android::ISurfaceComposer::eDisplayIdMain)
{
}

nn::Result nn::vi::detail::LcdDisplay::GetHotplugState(HotplugState* pOutState) const NN_NOEXCEPT
{
    NN_UNUSED(pOutState);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::LcdDisplay::SetUnderscan(int underscan) NN_NOEXCEPT
{
    NN_UNUSED(underscan);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::LcdDisplay::GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT
{
    *pOutUnderscan = 0;

    return nn::ResultSuccess();
}

nn::Result nn::vi::detail::LcdDisplay::GetHotplugEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT
{
    NN_UNUSED(pOutEvent);

    return nn::vi::ResultNotSupported();
}
