﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/vi/vi_HotplugState.h>
#include <nn/vi/vi_RgbRange.h>
#include <nn/vi/vi_PowerState.h>
#include <nn/vi/vi_LayerStack.h>

namespace nn { namespace vi {
    struct DisplayModeInfo;
}}

namespace nn { namespace vi { namespace detail {

    class IModeFilter;

    class IPhysicalDisplay
    {
    public:
        virtual ~IPhysicalDisplay() NN_NOEXCEPT;

        virtual nn::Result Open() NN_NOEXCEPT = 0;
        virtual void Close() NN_NOEXCEPT = 0;

        virtual nn::Result GetHotplugState(HotplugState* pOutState) const NN_NOEXCEPT = 0;
        virtual nn::Result GetMode(DisplayModeInfo* pOutMode) const NN_NOEXCEPT = 0;

        virtual int ListModes(DisplayModeInfo* pOutModes, int modeCountMax, const IModeFilter* pFilter) const NN_NOEXCEPT = 0;

        virtual nn::Result SetMode(const DisplayModeInfo* pMode, const IModeFilter* pFilter) NN_NOEXCEPT = 0;

        virtual int ListRgbRanges(RgbRange* pOutRanges, int rgbCountMax) const NN_NOEXCEPT = 0;
        virtual nn::Result GetRgbRange(RgbRange* pOutRange) const NN_NOEXCEPT = 0;
        virtual nn::Result SetRgbRange(RgbRange range) NN_NOEXCEPT = 0;

        virtual nn::Result SetUnderscan(int underscan) NN_NOEXCEPT = 0;
        virtual nn::Result GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT = 0;

        virtual nn::Result SetAlpha(float alpha) NN_NOEXCEPT = 0;

        virtual nn::Result SetPowerState(PowerState state) NN_NOEXCEPT = 0;

        virtual nn::Result SetLayerStack(LayerStack id) NN_NOEXCEPT = 0;

        virtual nn::Result SetCmuLuma(float luma) NN_NOEXCEPT = 0;
        virtual nn::Result GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT = 0;

        virtual nn::Result GetHotplugEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT = 0;
        virtual nn::Result GetVsyncEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT = 0;
    };

    int WriteCeFormatRgbRange(RgbRange* pOutRanges, int rgbCountMax, bool isSelectable) NN_NOEXCEPT;

}}}
