﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/edid.h>
#include <nn/settings/system/settings_Tv.h>
#include "vi_IPhysicalDisplay.h"

namespace nn { namespace vi { namespace detail {

    class EdidDisplay : public IPhysicalDisplay
    {
    public:
        EdidDisplay() NN_NOEXCEPT;

        virtual nn::Result Open() NN_NOEXCEPT NN_OVERRIDE;
        virtual void Close() NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetHotplugState(HotplugState* pOutState) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetMode(DisplayModeInfo* pOutMode) const NN_NOEXCEPT NN_OVERRIDE;

        virtual int ListModes(DisplayModeInfo* pOutModes, int modeCountMax, const IModeFilter* pFilter) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetMode(const DisplayModeInfo* pMode, const IModeFilter* pFilter) NN_NOEXCEPT NN_OVERRIDE;

        virtual int ListRgbRanges(RgbRange* pOutRanges, int rgbCountMax) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetRgbRange(RgbRange* pOutRange) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetRgbRange(RgbRange range) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetUnderscan(int underscan) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetAlpha(float alpha) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetPowerState(PowerState state) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetLayerStack(LayerStack id) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetCmuLuma(float luma) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetHotplugEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT NN_OVERRIDE;
    private:
        nn::settings::system::Edid m_Data;
        nn::edid::Edid m_Handle;

        struct DisplayModeVisitorData
        {
            int writeCount;
            const IModeFilter* pFilter;
            DisplayModeInfo* pOutModes;
            int modeCountMax;
        };

        static bool DisplayModeVisitor(const nn::edid::DisplayModeInfo* pMode,
                                       const nn::edid::DisplayTimingInfo* pTimingInfo,
                                       const nn::edid::ImageSizeInfo* pSizeInfo,
                                       void* pUserData) NN_NOEXCEPT;
    };

}}}
