﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkLog.h>
#include <nn/os/os_Mutex.h>

#define VI_LOG(msg) NN_SDK_LOG("vi: " msg "\n")

namespace nn { namespace vi { namespace detail {

    /**
     * @brief Queries if the library has been initialized.
     *
     * @return       Whether the library is initialized.
     * @retval true  The library is initialized.
     * @retval false The library is not initialized.
     */
    bool IsInitialized();

    nn::os::Mutex& GetInitializerLock() NN_NOEXCEPT;

}}}
