﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_StringUtil.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include "vi_Log.h"

namespace nn{ namespace vi{

    class DisplayHolder
        : public nn::util::IntrusiveListBaseNode<DisplayHolder>
    {
        NN_DISALLOW_COPY(DisplayHolder);
    public:

        DisplayHolder(DisplayId id, const char* name) NN_NOEXCEPT
            : m_Id(id)
            , m_OpenCount(0)
            , m_LayerCount(0)
        {
            NN_VI_LOG_LIFETIME("DisplayHolder ctor\n");
            nn::util::Strlcpy(m_Name.value, name, sizeof(DisplayName));
        }

        ~DisplayHolder() NN_NOEXCEPT
        {
            NN_VI_LOG_LIFETIME("DisplayHolder dtor\n");
            m_Id = 0;
            m_OpenCount = 0;
            m_LayerCount = 0;
            std::memset(&m_Name, 0, sizeof(m_Name));
        }

        DisplayId GetId() const NN_NOEXCEPT
        {
            return m_Id;
        }

        const char* GetName() const NN_NOEXCEPT
        {
            return m_Name.value;
        }

        const DisplayName& GetDisplayName() const NN_NOEXCEPT
        {
            return m_Name;
        }

        int GetOpenCount() const NN_NOEXCEPT
        {
            return m_OpenCount;
        }

        void IncrementOpenCount() NN_NOEXCEPT
        {
            m_OpenCount++;
        }

        void DecrementOpenCount() NN_NOEXCEPT
        {
            m_OpenCount--;
        }

        int GetLayerCount() const NN_NOEXCEPT
        {
            return m_LayerCount;
        }

        void IncrementLayerCount() NN_NOEXCEPT
        {
            m_LayerCount++;
        }

        void DecrementLayerCount() NN_NOEXCEPT
        {
            m_LayerCount--;
        }

    private:
        DisplayId m_Id;
        DisplayName m_Name;
        int m_OpenCount;
        int m_LayerCount;
    };

    typedef nn::util::IntrusiveList<
        DisplayHolder,
        nn::util::IntrusiveListBaseNodeTraits<DisplayHolder>
    > DisplayHolderList;

}}
