﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "vi_DeserializeNativeWindow.h"

#include <gui/IGraphicBufferProducer.h>
#include <gui/Surface.h>
#include <gui/SurfaceControl.h>

#include <nn/util/util_ScopeExit.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/vi/vi_Result.h>
#include "../native/vi_ParcelIo.h"

namespace nn{ namespace vi{ namespace native{

    nn::Result DeserializeNativeWindow(NativeWindowHolder* pOutValue, const void* pData, size_t dataSize) NN_NOEXCEPT
    {
        android::Parcel parcel;
        NN_RESULT_THROW_UNLESS(
            ParcelIo::OpenParcel(&parcel, pData, dataSize) == android::NO_ERROR,
            nn::vi::ResultOperationFailed()
        );
        NN_UTIL_SCOPE_EXIT
        {
            ParcelIo::CloseParcel(&parcel);
        };

        auto pProducer = android::interface_cast<android::IGraphicBufferProducer>(parcel.readStrongBinder());
        NN_RESULT_THROW_UNLESS(
            pProducer != nullptr,
            nn::vi::ResultOperationFailed()
        );

        pOutValue->pProducer = pProducer;
        pOutValue->pSurface = android::SurfaceControl::getSurface(pProducer);

        NN_RESULT_SUCCESS;
    }

}}}
