﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/detail/vi_ServiceReferenceHolder.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/vi/vi_Result.h>

namespace nn{ namespace vi{ namespace detail{

    namespace {
        nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService> g_pApplicationService = nullptr;
        nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>      g_pSystemService = nullptr;

        IndirectLayerTable* g_pIndirectLayerTable = nullptr;
    }

    nn::Result ServiceReferenceHolder::GetApplicationService(nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>* pOutService) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(g_pApplicationService != nullptr, nn::vi::ResultNotInitialized());
        *pOutService = g_pApplicationService;
        NN_RESULT_SUCCESS;
    }

    nn::Result ServiceReferenceHolder::GetSystemService(nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>* pOutService) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(g_pSystemService != nullptr, nn::vi::ResultNotInitialized());
        *pOutService = g_pSystemService;
        NN_RESULT_SUCCESS;
    }

    nn::Result ServiceReferenceHolder::GetIndirectLayerTable(IndirectLayerTable** pOutTable) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(g_pIndirectLayerTable != nullptr, nn::vi::ResultNotInitialized());
        *pOutTable = g_pIndirectLayerTable;
        NN_RESULT_SUCCESS;
    }

    void ServiceReferenceHolder::SetApplicationService(const nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>& pService) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(g_pApplicationService == nullptr);
        NN_SDK_REQUIRES_NOT_NULL(pService);
        g_pApplicationService = pService;
    }

    void ServiceReferenceHolder::SetSystemService(const nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>& pService) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(g_pSystemService == nullptr);
        NN_SDK_REQUIRES_NOT_NULL(pService);
        g_pSystemService = pService;
    }

    void ServiceReferenceHolder::SetIndirectLayerTable(IndirectLayerTable* pTable) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(g_pIndirectLayerTable == nullptr);
        NN_SDK_REQUIRES_NOT_NULL(pTable);
        g_pIndirectLayerTable = pTable;
    }

    void ServiceReferenceHolder::ResetApplicationService() NN_NOEXCEPT
    {
        g_pApplicationService.Reset();
    }

    void ServiceReferenceHolder::ResetSystemService() NN_NOEXCEPT
    {
        g_pSystemService.Reset();
    }

    void ServiceReferenceHolder::ResetIndirectLayerTable() NN_NOEXCEPT
    {
        g_pIndirectLayerTable = nullptr;
    }

}}}
