﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/vi_ServiceTypes.h>

#include "../vi_Config.h"
#include "../native/vi_DeserializeNativeWindow.h"

namespace nn{ namespace vi{ namespace detail{

    struct IndirectLayerEntry
    {
    public:
        void Clear() NN_NOEXCEPT;
    public:
        IndirectProducerHandleType handle;
        native::NativeWindowHolder window;
    };

    class IndirectLayerTable
    {
    public:
        static const int Capacity = IndirectLayerCountMax;

        enum EntryState
        {
            EntryState_Free,
            EntryState_Allocated,
        };

    public:
        IndirectLayerTable() NN_NOEXCEPT;

        nn::Result Allocate(int* pOutIndex) NN_NOEXCEPT;
        void Free(int index) NN_NOEXCEPT;

        int GetIndex(IndirectLayerEntry* pEntry) const NN_NOEXCEPT;
        IndirectLayerEntry& Get(int index) NN_NOEXCEPT;

    private:
        EntryState m_EntryStateList[Capacity];
        IndirectLayerEntry m_EntryList[Capacity];
    };

}}}
