﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "usb_HsPrivateIncludes.h"
#include "usb_HsServiceName.h"
#include <nn/nn_SystemThreadDefinition.h>

namespace nn { namespace usb { namespace hs {

Result ServiceManager::Initialize()
{
    Result result = ResultSuccess();

    NN_USB_ABORT_UNLESS_SUCCESS(InitializePort(0, HsLimitMaxSessionCount, ServiceName));

    this->Start();

    for (int32_t i = 0; i < NN_USB_ARRAY_COUNT32(m_SessionThreads); i++)
    {
        NN_USB_RETURN_UPON_ERROR(nn::os::CreateThread(&m_SessionThreads[i],
                                                      SessionThreadEntryStatic,
                                                      this, m_SessionThreadStack[i],
                                                      sizeof(m_SessionThreadStack[i]),
                                                      NN_SYSTEM_THREAD_PRIORITY(usb,HsIpcServer)));
        nn::os::SetThreadNamePointer(&m_SessionThreads[i], NN_SYSTEM_THREAD_NAME(usb, HsIpcServer));
    }
    for (int32_t i = 0; i < NN_USB_ARRAY_COUNT32(m_SessionThreads); i++)
    {
        nn::os::StartThread(&m_SessionThreads[i]);
    }


    return result;
}

Result ServiceManager::Finalize()
{
    Result result = ResultSuccess();

    return result;
}


Result ServiceManager::OnNeedsToAccept(int portIndex, PortForAllInOne *pPort) NN_NOEXCEPT
{
    return AcceptImpl(
        pPort,
        detail::Factory::CreateSharedEmplaced<IClientRootSession, ClientRootSession>(
            detail::UsbMemoryGetAllocator(),
            m_pHs
        )
    );
}


void ServiceManager::SessionThreadEntryStatic(void *arg) NN_NOEXCEPT
{
    ServiceManager *pThis = reinterpret_cast<ServiceManager *>(arg);
    pThis->LoopAuto();
}


} // end of namespace hs
} // end of namespace usb
} // end of namespace nn
