﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_DsController.h
 * @brief   USB Device Stack Device Controller Abstraction
 */

#include "usb_DsCommon.h"
#include "usb_DsProtocol.h"

#include "../detail/usb_Controller.h"
#include "../detail/usb_Complex.h"

namespace nn {
namespace usb {
namespace ds {

class DsController : public detail::UsbController
{
public:
    explicit DsController(uint32_t capability) NN_NOEXCEPT
        : detail::UsbController(capability | UsbCapability_Device)
    {
        // do nothing
    }

    virtual ~DsController() NN_NOEXCEPT
    {
        // do nothing
    }

    virtual Result Initialize(detail::UsbComplex* pComplex, detail::UsbController::Config* pConfig) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Finalize() NN_NOEXCEPT NN_OVERRIDE;

    // device functions
    virtual Result Attach() NN_NOEXCEPT =0;
    virtual Result Detach() NN_NOEXCEPT =0;
    virtual Result Ctrl(UsbCtrlRequest *pCtrl) NN_NOEXCEPT =0;
    virtual UsbDeviceSpeed GetConnectSpeed() NN_NOEXCEPT =0;

    // endpoint functions
    virtual Result EnableEndpoint(UsbEndpointDescriptor *pUsbEndpointDescriptor, UsbEndpointCompanionDescriptor *pUsbEndpointCompanionDescriptor) NN_NOEXCEPT =0;
    virtual Result DisableEndpoint(uint8_t bEndpointAddress) NN_NOEXCEPT =0;
    virtual Result FlushEndpoint(uint8_t bEndpointAddress) NN_NOEXCEPT =0;
    virtual Result StallEndpoint(uint8_t bEndpointAddress) NN_NOEXCEPT =0;
    virtual Result SetZlt (uint8_t bEndpointAddress, bool zlt) NN_NOEXCEPT =0;

    virtual Result PostBufferAsync(uint8_t   endpointAddress,
                                   nn::dd::ProcessHandle processHandle,
                                   uint64_t  procVa,
                                   uint32_t  bytes) NN_NOEXCEPT
    {
        NN_UNUSED(endpointAddress);
        NN_UNUSED(processHandle);
        NN_UNUSED(procVa);
        NN_UNUSED(bytes);
        return ResultResourceBusy();
    }


public:
    // protocol layer instance
    DsProtocol                  protocol;
};


} // end of namespace ds
} // end of namespace usb
} // end of namespace nn
