﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include "usb_Complex.h"
#include "usb_Platform.h"
#include "usb_Util.h"

namespace nn {
namespace usb {
namespace detail {

Result UsbComplex::Initialize(UsbPlatform *pPlatform) NN_NOEXCEPT
{
    m_pPlatform = pPlatform;

    return ResultSuccess();
}

Result UsbComplex::Finalize() NN_NOEXCEPT
{
    m_pPlatform = nullptr;

    return ResultSuccess();
}

Result UsbComplex::AddController(UsbController *pController,
                                 UsbController::Config* pConfig) NN_NOEXCEPT
{
    Result result;

    result = pController->Initialize(this, pConfig);
    if (result.IsSuccess())
    {
        m_ControllerList.push_back(pController);
    }

    return result;
}

Result UsbComplex::DelController(UsbController *pController) NN_NOEXCEPT
{
    m_ControllerList.remove(pController);

    return pController->Finalize();
}

UsbController *UsbComplex::GetController(uint32_t capability) NN_NOEXCEPT
{
    for (UsbController *controller : m_ControllerList)
    {
        // looking for a controller which has all the capabilities required
        if ((controller->GetCapability() & capability) == capability)
        {
            return controller;
        }
    }

    return nullptr;
}

UsbPlatform *UsbComplex::GetPlatform() const NN_NOEXCEPT
{
    NN_USB_ABORT_IF_NULL(m_pPlatform);
    return m_pPlatform;
}

nn::os::Event* UsbComplex::GetResetEvent() NN_NOEXCEPT
{
    return &m_ResetEvent;
}

void UsbComplex::RequestReset() NN_NOEXCEPT
{
    m_ResetEvent.Signal();
}

} // end of namespace detail
} // end of namespace usb
} // end of namespace nn
