﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/updater/updater.h>
#include "updater_Common.h"
#include "updater_PartitionAccessor.h"

namespace nn { namespace updater {

struct BisSaveRaw
{
    uint8_t data[BctSize];
};

class BisSave
{
    NN_DISALLOW_COPY(BisSave);
public:
    BisSave() NN_NOEXCEPT;
    Result Initialize(void* workBuffer, size_t size) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    Result Load() NN_NOEXCEPT;
    Result Save() NN_NOEXCEPT;

    bool GetVerifyingRequiredFlag(TargetBootMode mode) NN_NOEXCEPT;
    void SetVerifyingRequiredFlag(TargetBootMode mode, bool verifyingRequired) NN_NOEXCEPT;

private:
    BisSaveRaw*            m_SaveData;
    BootPartition1Accessor m_Accessor;
};

}}
