﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/uart/uart_PortName.h>
#include <nn/uart/uart_PortTypes.h>
#include <nn/os/os_InterruptEvent.h>

namespace nn {
namespace uart {
namespace driver {
namespace detail {

// ポート総数（番号は 0 始まりのため、この値未満の非負整数がポート番号として使用できる）
const int PortCountMax = 1;

// ハンドルする割り込み番号の数
const int InterruptCountMax = 1;

// 割り込み番号テーブル
const nn::os::InterruptName InterruptNameUartA = 32 + 36;
const nn::os::InterruptName InterruptNameUartB = 32 + 37;
const nn::os::InterruptName InterruptNameUartC = 32 + 46;
const nn::os::InterruptName InterruptNameUartD = 32 + 90;
const nn::os::InterruptName InterruptNameTable[InterruptCountMax] =
{
    InterruptNameUartB
};

// ポートと割り込み番号の対応表
const nn::os::InterruptName AssignedInterrupt[PortCountMax] =
{
    InterruptNameUartB // Port 0
};


// サポートしていないポートとして使用する番号
const int UnsupportedPortIndex = -1;

// 外部の定義と内部ポート番号の組み合わせの構造体の定義
struct PortMapCombination
{
    PortName publicPortName;
    int      portIndex;
};

// 外部の定義と内部のポート番号への変換一覧
const PortMapCombination PortMapCombinationList[] =
{
    // 公開ヘッダーの定義   内部のポート番号
    { PortName_Bluetooth,   0 },
};

// 対応ボーレートリスト
struct BaudRateSupportInfo
{
    int      portIndex;
    BaudRate baudRate;
};
const BaudRateSupportInfo SupportedBaudRateList[] =
{
    {0, BaudRate_57600},
    {0, BaudRate_115200}
};

// 対応フロー制御モードリスト
struct FlowControlModeSupportInfo
{
    int             portIndex;
    FlowControlMode flowControlMode;
};
const FlowControlModeSupportInfo SupportedFlowControlModeList[] =
{
    {0, FlowControlMode_None},
    {0, FlowControlMode_Hardware} // General Expansion Header 経由で配線していることが前提
};

// 対応ポートイベントリスト
struct PortEventSupportInfo
{
    int           portIndex;
    PortEventType eventType;
};
const PortEventSupportInfo SupportedPortEventList[] =
{
    {0, PortEventType_SendBufferEmpty},
    {0, PortEventType_SendBufferReady},
    {0, PortEventType_ReceiveBufferReady},
    {0, PortEventType_ReceiveEnd}
};


} // detail
} // driver
} // uart
} // nn
