﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_BitPack.h>

#include <nne/dma/dma.h>
#include <nn/os/os_SystemEvent.h>

#include "uart_CircularBuffer.h"
#include "uart_PortStatus.h"
#include "uart_TargetSpec.h"

namespace nn {
namespace uart {
namespace driver {
namespace detail {

// TORIAEZU : 名前を変えた方がいいかも
const int DmaBufferAlign = 4;

enum DmaChannelIndex
{
    DmaChannelIndex_Send    = 0,
    DmaChannelIndex_Receive = 1,
    DmaChannelIndex_Max
};

class DmaAccessor
{
    NN_DISALLOW_COPY(DmaAccessor);
    NN_DISALLOW_MOVE(DmaAccessor);

public:
    DmaAccessor() NN_NOEXCEPT :
        m_PortIndex(0),
        m_RestDataSize(0)
    {}

    void Initialize(int portIdx) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Start(const nn::dd::PhysicalAddress uartPhysicalAddress) NN_NOEXCEPT;
    void Stop() NN_NOEXCEPT;
    bool CopyDataFromDmaBufferToCircularBuffer(PortStatus& outErrorStatus, CircularBuffer& receiveBuffer) NN_NOEXCEPT;
    bool IsDmaComplete(DmaChannelIndex index) NN_NOEXCEPT;
    void SetSendDmaTransferSize(size_t size)  NN_NOEXCEPT;
    void RequestSendDataByDma(CircularBuffer& sendBuffer) NN_NOEXCEPT;
    bool AbortReceiveDataTransfer(PortStatus& outErrorStatus, CircularBuffer& receiveBuffer) NN_NOEXCEPT;
    void RequestReceiveDataByDma() NN_NOEXCEPT;
    bool MoveRestDataToCircularBuffer(PortStatus& outErrorStatus, CircularBuffer& receiveBuffer) NN_NOEXCEPT;
    void RunInterruptHandler(int channelIndex) NN_NOEXCEPT;
    void SuspendDmaTransfer() NN_NOEXCEPT;
    void ResumeDmaTransfer(const nn::dd::PhysicalAddress uartPhysicalAddress) NN_NOEXCEPT;
    bool IsRestDataExist()
    {
        return (m_RestDataSize > 0);
    }

private:

    int             m_PortIndex;
    size_t          m_RestDataSize;

    // DMA 制御用のパラメータ
    struct DmaParams
    {
        nne::dma::tegra::SessionHandle sessionHandle;
        nne::dma::tegra::ClientBuffer  clientBuffer;
        nn::os::SemaphoreType          completeSemaphore;
        char*                          buffer;
    } m_DmaParams[DmaChannelCountPerPort];
};

} // detail
} // driver
} // uart
} // nn
