﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName

#include <nn/ts/impl/ts.h>
#include <nn/ts/server/ts_HipcServiceName.h>
#include <nn/ts/server/ts_IMeasurementServer.autogen.h>
#include <nn/ts/server/ts_MeasurementServer.h>

#include "ts_CreateServerProxy.h"

namespace nn {
namespace ts {

namespace {

// 拡張ヒープを使用したアロケータを HIPC プロキシ用に準備
const size_t HicpHeapSizeByte  = 8 * 1024; // TODO: たぶん多すぎるので減らす
typedef ::nn::sf::ExpHeapStaticAllocator<HicpHeapSizeByte, server::IMeasurementServer> Allocator;

class AllocatorInitializer
{
public:

    AllocatorInitializer() NN_NOEXCEPT
    {
        Allocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_AllocatorInitializer;

}


::nn::sf::SharedPointer<server::IMeasurementServer> CreateMeasurementServerProxy() NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<server::IMeasurementServer> ret;
    auto result = ::nn::sf::CreateHipcProxyByName<server::IMeasurementServer, Allocator::Policy>(&ret, server::MeasurementServiceName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

} // ts
} // nn
