﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/result/result_HandlingUtility.h>

#include <nn/ts/impl/ts.h>

#include "detail/ts_ResourceManager.h"
#include "detail/ts_ISensorController.h"

namespace nn {
namespace ts {
namespace impl {


nn::Result Initialize() NN_NOEXCEPT
{
    return detail::InitializeResourceManager();
}



nn::Result Finalize() NN_NOEXCEPT
{
    return detail::FinalizeResourceManager();
}



LimitTemperature GetTemperatureRange(Location location) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsLocationValid(location));

    auto& controller = detail::GetSensorController(location);

    return controller.GetTemperatureRange();
}



nn::Result GetTemperature(int* pOutTemperature, Location location) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsLocationValid(location));

    auto& controller = detail::GetSensorController(location);

    return controller.GetTemperature(pOutTemperature);
}

nn::Result GetTemperatureMilliC(int* pOutTemperatureMilliC, Location location) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsLocationValid(location));

    auto& controller = detail::GetSensorController(location);

    return controller.GetTemperatureMilliC(pOutTemperatureMilliC);
}

void SetMeasurementMode(Location location, MeasurementMode measurementMode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsLocationValid(location));

    auto& controller = detail::GetSensorController(location);

    return controller.SetMeasurementMode(measurementMode);
}



// TODO: 以下の関数は追って実装

bool OpenSession(DetectionSession* pOutSession, Location location) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(location);

    return true;
}



void CloseSession(DetectionSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}



int GetMaxDetectionSettingsSize(DetectionSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);

    return 0;
}



void GetDetectionSettings(LimitTemperature* pOutSettings, DetectionSession* pSession, int size) NN_NOEXCEPT
{
    NN_UNUSED(pOutSettings);
    NN_UNUSED(pSession);
    NN_UNUSED(size);
}



int SetDetectionSettings(DetectionSession* pSession, const LimitTemperature& limitSettings, int size) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(limitSettings);
    NN_UNUSED(size);

    return 0;
}



ExceededStatus GetDetectedStatus(DetectionSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);

    return ExceededStatus {false,false};
}



nn::Result BindDetectionEvent(DetectionSession* pSession, nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(pOutEvent);

    NN_RESULT_SUCCESS;
}



void UnbindDetectionEvent(DetectionSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}



bool GetDetectionEventEnabled(DetectionSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return false;
}



void SetDetectionEventEnabled(DetectionSession* pSession, bool enable) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(enable);
}


}}} // nn::ts::impl
