﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include <nn/nn_Common.h>

#include <nn/ts/detail/ts_Log.h>

#include "ts_SettingsHolder.h"

namespace nn { namespace ts { namespace impl { namespace detail {

SettingsHolder::SettingsHolder() NN_NOEXCEPT
    : m_RemoteTemperatureOffsetMilliC(0)
    , m_RemoteShutdownTemperatureHighLimitMilliC(96000)
{
    // 何も処理をしない。
}

void SettingsHolder::LoadSettings() NN_NOEXCEPT
{
    m_FirmwareDebugSettingsAccessor.ReadSetting(&m_RemoteTemperatureOffsetMilliC, "remote_temperature_offset_milli_c");
    m_FirmwareDebugSettingsAccessor.ReadSetting(&m_RemoteShutdownTemperatureHighLimitMilliC, "remote_shutdown_temperature_high_limit_milli_c");
}

int SettingsHolder::GetRemoteTemperatureOffsetMilliC() NN_NOEXCEPT
{
    return m_RemoteTemperatureOffsetMilliC;
}

int SettingsHolder::GetRemoteShutdownTemperatureHighLimitMilliC() NN_NOEXCEPT
{
    return m_RemoteShutdownTemperatureHighLimitMilliC;
}

}}}} // namespace nn::ts::impl::detail
