﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <climits>
#include <mutex>

#include <nn/nn_Common.h>

#include <nn/ts/detail/ts_Log.h>
#include <nn/ts/impl/ts.h>
#include <nnd/tmp451/tmp451.h>

#include "ts_ISensorController.h"
#include "ts_SensorControllerImpl-hardware.nx.h"

#include "ts_DeviceControllerImpl.tmp451.h"

namespace nn {
namespace ts {
namespace impl {
namespace detail {

//namespace {
//static const LimitTemperature g_NotSupportSensorLimit =  {-128, 127};
//}

////-------------------------------------------
//// SocCpuController
//void SocCpuController::Initialize() NN_NOEXCEPT
//{
//}
//
//
//void SocCpuController::Finalize() NN_NOEXCEPT
//{
//}
//
//
//LimitTemperature SocCpuController::GetTemperatureRange() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit;
//}
//
//
//int SocCpuController::GetTemperature() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit.low;
//}
//
////-------------------------------------------
//// SocGpuController
//void SocGpuController::Initialize() NN_NOEXCEPT
//{
//}
//
//
//void SocGpuController::Finalize() NN_NOEXCEPT
//{
//}
//
//
//LimitTemperature SocGpuController::GetTemperatureRange() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit;
//}
//
//
//int SocGpuController::GetTemperature() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit.low;
//}
//
////-------------------------------------------
//// Location_SocPll
//void SocPllController::Initialize() NN_NOEXCEPT
//{
//}
//
//
//void SocPllController::Finalize() NN_NOEXCEPT
//{
//}
//
//
//LimitTemperature SocPllController::GetTemperatureRange() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit;
//}
//
//
//int SocPllController::GetTemperature() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit.low;
//}
//
////-------------------------------------------
//// Location_SocMem
//void SocMemController::Initialize() NN_NOEXCEPT
//{
//}
//
//
//void SocMemController::Finalize() NN_NOEXCEPT
//{
//}
//
//
//LimitTemperature SocMemController::GetTemperatureRange() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit;
//}
//
//
//int SocMemController::GetTemperature() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit.low;
//}

//-------------------------------------------
// ThermalSensorInternalController
nn::Result ThermalSensorInternalController::Initialize() NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().InitializeDevice();
}


nn::Result ThermalSensorInternalController::Finalize() NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().FinalizeDevice();
}


LimitTemperature ThermalSensorInternalController::GetTemperatureRange() NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().GetTemperatureRange(nnd::tmp451::Location::Local);
}


nn::Result ThermalSensorInternalController::GetTemperature(int* pOutTemperature) NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().GetTemperature(pOutTemperature, nnd::tmp451::Location::Local);
}

nn::Result ThermalSensorInternalController::GetTemperatureMilliC(int* pOutTemperatureMilliC) NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().GetTemperatureMilliC(pOutTemperatureMilliC, nnd::tmp451::Location::Local);
}

void ThermalSensorInternalController::SetMeasurementMode(MeasurementMode measurementMode) NN_NOEXCEPT
{
    nn::Result result;

    switch (measurementMode)
    {
    case MeasurementMode::Standby:
        result = Tmp451Controller::GetInstance().SetMeasurementMode(nnd::tmp451::MeasurementMode::Standby);
        break;
    case MeasurementMode::Continuous:
        result = Tmp451Controller::GetInstance().SetMeasurementMode(nnd::tmp451::MeasurementMode::Continuous);
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }

    // 失敗の Result を返すことはできないので、エラーはログを出しつつ丸める。
    if (result.IsFailure())
    {
        NN_DETAIL_TS_ERROR("Tmp451Controller returns failure result.\n");
    }
}

//-------------------------------------------
// ThermalSensorExternalController
nn::Result ThermalSensorExternalController::Initialize() NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().InitializeDevice();
}


nn::Result ThermalSensorExternalController::Finalize() NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().FinalizeDevice();
}


LimitTemperature ThermalSensorExternalController::GetTemperatureRange() NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().GetTemperatureRange(nnd::tmp451::Location::Remote);
}


nn::Result ThermalSensorExternalController::GetTemperature(int* pOutTemperature) NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().GetTemperature(pOutTemperature, nnd::tmp451::Location::Remote);
}

nn::Result ThermalSensorExternalController::GetTemperatureMilliC(int* pOutTemperatureMilliC) NN_NOEXCEPT
{
    return Tmp451Controller::GetInstance().GetTemperatureMilliC(pOutTemperatureMilliC, nnd::tmp451::Location::Remote);
}

void ThermalSensorExternalController::SetMeasurementMode(MeasurementMode measurementMode) NN_NOEXCEPT
{
    nn::Result result;

    if (measurementMode == MeasurementMode::Standby)
    {
        result = Tmp451Controller::GetInstance().SetMeasurementMode(nnd::tmp451::MeasurementMode::Standby);
    }
    else
    {
        result = Tmp451Controller::GetInstance().SetMeasurementMode(nnd::tmp451::MeasurementMode::Continuous);
    }

    // 失敗の Result を返すことはできないので、エラーはログを出しつつ丸める。
    if (result.IsFailure())
    {
        NN_DETAIL_TS_ERROR("Tmp451Controller returns failure result.\n");
    }
}

////-------------------------------------------
//// BatteryController
//void BatteryController::Initialize() NN_NOEXCEPT
//{
//}
//
//
//void BatteryController::Finalize() NN_NOEXCEPT
//{
//}
//
//
//LimitTemperature BatteryController::GetTemperatureRange() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit;
//}
//
//
//int BatteryController::GetTemperature() NN_NOEXCEPT
//{
//    // TODO: 暫定実装
//    return g_NotSupportSensorLimit.low;
//}



}}}} // nn::ts::impl::detail
