﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma  once

#include "tmipc_result.h"
#include "tmipc_service_ids.h"
#include "tmipc_task_type.h"

namespace tmipc {

static_assert(TaskType_Invalid                      ==  0, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileOpen                  ==  1, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileGetSize               ==  2, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileSetSize               ==  3, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileGetSizeFromPath       ==  4, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileExists                ==  5, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileRead                  ==  6, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileWrite                 ==  7, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileFlush                 ==  8, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileSetPriority           ==  9, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileGetPriority           == 10, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileClose                 == 11, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileCreate                == 12, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileDelete                == 13, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioFileRename                == 14, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioGetIoType                 == 15, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectoryExists           == 16, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectoryOpen             == 17, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectoryGetEntryCount    == 18, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectoryRead             == 19, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectoryClose            == 20, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectorySetPriority      == 21, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectoryGetPriority      == 22, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectoryCreate           == 23, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectoryDelete           == 24, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioDirectoryRename           == 25, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsSocket                   == 26, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsClose                    == 27, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsConnect                  == 28, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsBind                     == 29, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsListen                   == 30, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsAccept                   == 31, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsRecv                     == 32, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsSend                     == 33, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsShutdown                 == 34, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HtcsFcntl                    == 35, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HidControllerRead            == 36, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_WaitForLaunchTask            == 37, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_DebugTask                    == 38, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_BenchmarkReport              == 39, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_BenchmarkTask                == 40, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_EnvGetVar                    == 41, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_LogTask                      == 42, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_HioGetFileTimeStamp          == 43, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_PowerManagementTask          == 44, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_SettingsTask                 == 45, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_TIOFileOpen                  == 46, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOFileClose                 == 47, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOFileRead                  == 48, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOFileWrite                 == 49, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOFileSetSize               == 50, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOFileDelete                == 51, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOFileMove                  == 52, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOFileGetInformation        == 53, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOFileSetAttributes         == 54, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOFileSetTime               == 55, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_TIODirectoryCreate           == 56, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIODirectoryDelete           == 57, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIODirectoryMove             == 58, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIODirectoryGetInformation   == 59, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_TIOSearchFetch               == 60, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOGetFreeSpace              == 61, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TIOGetVolumeInformation      == 62, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_DoNotUseSlot63               == 63, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_DoNotUseSlot64               == 64, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_MiniCoreDumpTask             == 65, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_TMSInfoSupport               == 66, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_ThreadFrozenTask             == 67, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_CoredumpStartTask            == 68, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_DiagnosticsTask              == 69, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_PerformanceMonitorTask       == 70, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_GetWorkingDirectoryPath      == 71, "Backwards compatibility violation: TaskType enumeration sequence has changed." );
static_assert(TaskType_GetWorkingDirectoryPathSize  == 72, "Backwards compatibility violation: TaskType enumeration sequence has changed." );

static_assert(TaskType_BackwardsCompatibilitySentinel == 73,
                                    "Backwards compatibility notification: TaskType_BackwardsCompatibilitySentinel"
                                    "has changed; this occured because a new task type enumeration was added which"
                                    "caused the value of the sentinel to change.  Please add a static_assert just"
                                    "like the ones you see (above) for any tasks that you have added, then repair this"
                                    "assert by comparing to the new value of the sentinel." );


static_assert(ServiceId_DebugService                == 0xddde6636, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_ControllerService           == 0x0955e925, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_LogService                  == 0x373e20c5, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_LaunchService               == 0x3ac1167b, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_EnvService                  == 0xc191dac9, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_HostIOService               == 0x5fae4d7e, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_HostDirectoryIOService      == 0xb04489f2, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_HTCSService                 == 0xb644d830, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_ChannelService              == 0x41d1ae3f, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_BenchmarkReportService      == 0x378d2db4, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_BenchmarkService            == 0xba2c1174, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_PerformanceMonitorService   == 0xa148f3a6, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_PowerManagementService      == 0xcc11bcfd, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_SettingsService             == 0x8a4f6b62, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_ThreadFrozenService         == 0x5898b956, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_CoreDumpService             == 0x50bf64e6, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_TargetIOService             == 0x8e69bdd7, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_GenericService              == 0x58cf2177, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_NodeTICS_BeaconQuery        == 0x30eb2f3a, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_NodeTICS_TMSInfo            == 0xf8da3cd6, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_NodeUSB_BeaconQuery         == 0x3a8ddd94, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_NodeUSB_TMSInfo             == 0x4d4a6c24, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_NodeUSB_ConnectHandshake    == 0xcd5ed1b8, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_NodeUSB_Disconnect          == 0xf97fe6b9, "Backwards compatibility violation: ServiceId has changed." );
static_assert(ServiceId_BackwardsCompatibilitySentinel == ServiceId_NodeUSB_Disconnect + 1,
                                    "Backwards compatibility sentinel has changed; this occurred because a new "
                                    "service id enumeration was added and caused the value of the sentinal to "
                                    "change.  This error helps to ensure that you maintain backwards compatibility. "
                                    "Please add a static_assert just like the ones you see (above) for any new "
                                    "services that you have added, then repair this assert by comparing to the "
                                    "new value of the sentinel.");



static_assert(TMIPC_RESULT_OK                       ==  0, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_NOT_IMPLEMENTED          ==  1, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_FAILED                   ==  2, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_CONNECT_FAILED           ==  3, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_CONNECT_NODE_IN_USE      ==  4, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_CONNECT_VERSION_ERROR    ==  5, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_PACKET_OVERRUN           ==  6, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_USER_BUFFER_OVERRUN      ==  7, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_DISCONNECTED             ==  8, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_DUPLICATE_SERVICE        ==  9, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_UNKNOWN_SERVICE          == 10, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_CANCELED                 == 11, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_TIMEOUT                  == 12, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_NOT_INITIALIZED          == 13, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_INVALID_PARAMETER        == 14, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_CONNECT_PROTOCOL_ERROR   == 15, "Backwards compatibility violation: tmipc::Result has changed." );
static_assert(TMIPC_RESULT_NOT_BACKWARDS_COMPATIBLE == 16, "Backwards compatibility violation: tmipc::Result has changed." );


static_assert(TMIPC_RESULT_BACKWARDS_COMPATIBILITY_SENTINEL == 18,
                                    "Bbackwards compatibility sentinel has changed; this occurred because a new "
                                    "error code was added to tmipc::Result or the integral values of the enumeration "
                                    "have changed.  This error helps to ensure that you maintain backwards "
                                    "compatibility.  Please add a static_assert just like the ones you see (above) "
                                    "for any new error codes that you have added, then repair this assert by the "
                                    "comparing to the new value of the sentinel.");


} // namespace tmipc
