﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//------------------------------------------------------------------------------
//
//  Configurable options:
//
//    - ENABLE_MEM_MGR - If defined, enables the mem_mgr within the TinyEngine.
//          If not defined, then all heap funtions compile directly into their
//          standard library heap function analogs.
//
//    - ENABLE_SOURCE_CODE_INFO - If defined, allows the TinyEngine's mem_mgr to
//          note source code file name and line number.  The file/line
//          information is provided to the DejaLib instrumentation.
//
//------------------------------------------------------------------------------

// Comment/uncomment these two macros as needed.
// Alternately define them based on the project configuration.

#define ENABLE_MEM_MGR
// Conflicts with STL usage
//#define ENABLE_SOURCE_CODE_INFO

//------------------------------------------------------------------------------
//
//  The interface is as follows:
//
//      malloc              - Defined into call to tiny_malloc.
//      realloc             - Defined into call to tiny_realloc.
//      free                - Defined into call to tiny_free.
//
//      operator new        - Replaces default global operator new.
//      operator new []     - Replaces default global operator new [].
//      operator delete     - Replaces default global operator delete.
//      operator delete []  - Replaces default global operator delete [].
//
//------------------------------------------------------------------------------

//==============================================================================
//  FUNCTIONS
//==============================================================================

// Only use this memmgr as a default heap for TMA with the device.
// Win32 will use either a custom allocator passed in or the system defaults.
#ifdef ENABLE_MEM_MGR
#ifndef WIN32
void  memmgr_init           ();
void  memmgr_report         ();

extern "C" void free        ( void* p );

void* operator new          ( size_t Size );
void* operator new    []    ( size_t Size );

void  operator delete       ( void* p ) NN_NOEXCEPT;
void  operator delete []    ( void* p ) NN_NOEXCEPT;

void* operator new          ( size_t Size, const char*    pFileName, int Line );
void* operator new          ( size_t Size, const wchar_t* pFileName, int Line );
void* operator new    []    ( size_t Size, const char*    pFileName, int Line );
void* operator new    []    ( size_t Size, const wchar_t* pFileName, int Line );

void  operator delete       ( void* p,     const char*    pFileName, int Line );
void  operator delete       ( void* p,     const wchar_t* pFileName, int Line );
void  operator delete []    ( void* p,     const char*    pFileName, int Line );
void  operator delete []    ( void* p,     const wchar_t* pFileName, int Line );
#endif
#ifdef ENABLE_SOURCE_CODE_INFO
#define new new( __FILE__, __LINE__ )
#endif

#endif

//==============================================================================
