﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#if !defined(NN_TMA_SIM_INSTANCE)

#include <nn/os.h>

namespace tma
{
    namespace ThreadTracker
    {
        enum class ThreadId : s32
        {
            NotTracked = 0,         // Not tracked.  Examples: CS, dbg_Task threads, ...
            HioServer,              // tma::HipcHioServerFunction.
            HtcServer,              // tma::HipcHtcServerFunction.
            HtcsServer0,            // tma::HipcHtcsServerFunction[0].
            HtcsServer1,            // tma::HipcHtcsServerFunction[1].
            HtcsServer2,            // tma::HipcHtcsServerFunction[2].
            HtcsServer3,            // tma::HipcHtcsServerFunction[3].
            HtcsServer4,            // tma::HipcHtcsServerFunction[4].
            HtcsServer5,            // tma::HipcHtcsServerFunction[5].
            HtcsServer6,            // tma::HipcHtcsServerFunction[6].
            HtcsServer7,            // tma::HipcHtcsServerFunction[7].
            Main,                   // tma's main thread.
            PowerManagement,        // tma::PowerManagementMonitor::TmaPmModuleThread.
            TmipcListen,            // Examples: NodeTICS::Listen, USBInterface::IndicationPollingThread, ...
            TmipcReceive,           // Examples: NodeTICS::ReceiveThread, NodeUSB::ReceiveThread, ...
            TmipcSend,              // Examples: NodeTICS::SendThread, NodeUSB::SendThread, ...
            TmipcSession,           // Examples: TICSInterface::SessionThread, ...
            ServicesManager,        // ServicesManager::WorkThread.

            // Add more thread id's before this one.
            Count
        };

        // Initialize the Thread Tracker.
        void Initialize();

        // Finalize the Thread Tracker.
        void Finalize();

        // Registers a thread into the ThreadTypes array.
        void RegisterThread( const nn::os::ThreadType& Thread, ThreadId Id );

        // Unregisters the thread.
        void UnregisterThread( ThreadId Id );

        // Returns the ThreadType for Id.
        const nn::os::ThreadType& GetThreadType( ThreadId Id );
    }
}

#endif // NN_TMA_SIM_INSTANCE
