﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "power_management_task.h"
#include <nn/nn_SdkLog.h>

//==============================================================================
namespace tma { namespace powermanagement {
//==============================================================================

//==============================================================================

Task::Task()
{
//NN_SDK_LOG( "[powermanagement::Task::Task( 0x%p )]\n", this );
    m_TaskType = tmipc::TaskType_PowerManagementTask;
    SetCanBePutToSleep( false );
}

//==============================================================================

Task::~Task()
{
//NN_SDK_LOG( "[powermanagement::Task::~Task( 0x%p )]\n", this );
}

//==============================================================================

void Task::OnInitiate( tmipc::Packet* pPacket )
{
//NN_SDK_LOG( "[powermanagement::OnInitiate( 0x%p )]\n", this );
    (void)pPacket;
    ASSERT( 0 );
}

//==============================================================================

void Task::OnRecvPacket( tmipc::Packet* pPacket )
{
//NN_SDK_LOG( "[powermanagement::OnRecvPacket( 0x%p )]\n", this );
    // No processing, just complete the task on a packet.
    (void)pPacket;
    Complete();
}

//==============================================================================

void Task::OnSendPacket( tmipc::Packet* pPacket )
{
//NN_SDK_LOG( "[powermanagement::OnSendPacket( 0x%p )]\n", this );
    // TODO - Handle Packet
    (void)pPacket;
    ASSERT( 0 );
}

//==============================================================================
}}
//==============================================================================
