﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/htcs/htcs_Types.h>
#include "..\tmagent.h"
#include "..\tma\tma_MQ.h"
#include "..\tma\tma_Mutex.h"
#include "..\tmipc\tmipc_task.h"
#include "..\tmipc\tmipc_packet.h"
#include "..\tmipc\tmipc_service.h"
#include "htcs_task.h"
#include <vector>

//==============================================================================
namespace tma { namespace htcs {
//==============================================================================

class AgentHTCSService : public tmipc::Service
{
private:
    struct waiting_task*        m_pWaitingTasks;
    tma::Mutex                  m_TaskMutex; // Mutex to protect waiting list.

    // Number of events out.
    int32_t                     m_NumberOfEventsCreated;
    tma::Mutex                  m_EventCountMutex; // Mutex to protect event counter

    int32_t*                    m_pCloseOnConnectSockets;
    int32_t                     m_NumberOfSocketsToCloseOnConnect;
    tma::Mutex                  m_CloseOnConnectMutex;
public:
                        AgentHTCSService    ();
                       ~AgentHTCSService    ();

    void                Init        ( void );
    void                Kill        ( void );
    void                MemoryReport( void );

    //==============================================================================
    // Our services API

    HTCSSocketTask*     Socket      ( void );

    HTCSCloseTask*      Close       ( int                           descriptor );

    HTCSConnectTask*    Connect     ( int                           descriptor,
                                      const nn::htcs::SockAddrHtcs* pAddr );

    HTCSBindTask*       Bind        ( int                           descriptor,
                                      const nn::htcs::SockAddrHtcs* pAddr );

    HTCSListenTask*     Listen      ( int                       descriptor,
                                      int                       backlogCount );

    HTCSShutdownTask*   Shutdown    ( int                       descriptor,
                                      int                       how );

    HTCSFcntlTask*      Fcntl       ( int                       descriptor,
                                      int                       command,
                                      int                       value );

    DeprecatedAcceptTask* Accept( int                       descriptor,
                                      nn::htcs::SockAddrHtcs*   pAddr );

    DeprecatedRecvTask* Recv    ( int                       descriptor,
                                      void*                     pBuffer,
                                      size_t                    bufferByteSize,
                                      int                       flags );

    DeprecatedSendTask* Send    ( int                       descriptor,
                                      const void*               pBuffer,
                                      size_t                    bufferByteSize,
                                      int                       flags );

    int                 AcceptStart ( int                       descriptor,
                                      nn::os::NativeHandle*     pWaitHandle,
                                      uint32_t*                 pTaskId );

    int                 AcceptResults( uint32_t                 TaskId,
                                       nn::htcs::SockAddrHtcs*  address,
                                       int*                     pLastError );

    int                 RecvStart   ( int                  descriptor,
                                      int64_t                   bufferByteSize,
                                      int                       flags,
                                      nn::os::NativeHandle*     pWaitHandle,
                                      uint32_t*                 pTaskId );

    int                 RecvLargeStart( int                     descriptor,
                                        int32_t                 unalignedStartSize,
                                        int32_t                 unalignedEndSize,
                                        int64_t                 alignedSendSize,
                                        nn::os::NativeHandle    alignedMemoryHandle,
                                        int                     flags,
                                        nn::os::NativeHandle*   pWaitHandle,
                                        uint32_t*               pTaskId );

    int                 RecvResults ( uint32_t                  TaskId,
                                      void*                     pBuffer,
                                      size_t                    bufferByteSize,
                                      int64_t*                  pReceivedSize,
                                      int*                      pLastError );

    int                 SendLargeStart ( int                    descriptor,
                                      const void*               pUnalignedStart,
                                      int32_t                   unalignedStartSize,
                                      const void*               pUnalignedEnd,
                                      int32_t                   unalignedEndSize,
                                      nn::os::NativeHandle      alignedMemoryHandle,
                                      int64_t                   alignedSendSize,
                                      int                       flags,
                                      nn::os::NativeHandle*     pWaitHandle,
                                      uint32_t*                 pTaskId );

    int                 SendStart   ( int                       descriptor,
                                      const void*               pBuffer,
                                      int32_t                   bufferByteSize,
                                      int                       flags,
                                      nn::os::NativeHandle*     pWaitHandle,
                                      uint32_t*                 pTaskId );

    int                 SendResults ( uint32_t                  TaskId,
                                      int*                      pLastError );

    //==============================================================================
    // Waiting tasks results
    void                OnAcceptComplete( HTCSAcceptTask*   pTask );
    void                OnRecvComplete  ( HTCSRecvTask*     pTask );
    void                OnRecvComplete  ( HTCSRecvLargeTask* pTask );
    void                OnSendComplete  ( HTCSSendTask*     pTask );
    void                OnSocketClosed  ( int descriptor );
    void                OnSignalEventCreated    ();
    void                OnSignalEventDestroyed  ();
    void                OnSocketCloseFailed     ( int descriptor );
    void                OnSocketCreated         ( int descriptor );

protected:
virtual tmipc::Task*    OnNewTask   ( tmipc::Packet*             pPacket );
template <class T> T*   CreateTask  ( int Socket );

    //==============================================================================
    // Waiting task maintenance functionality
    uint32_t            RememberTask( waiting_task* pTask );
    waiting_task*       RecallTask  ( uint32_t      TaskId );
    void                ForgetTask  ( uint32_t      TaskId );
    void                OnClose     ( int           descriptor );
    bool                EventAvailable();
};

//==============================================================================
// Global HTCS service object.
AgentHTCSService&     GetHTCSService( void );


//==============================================================================
}}
//==============================================================================
