﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/tma/sf/tma_IHtcsManager.sfdl.h>
#include "htcs_HtcsManagerImpl.h"
#include <nn/sf/sf_Types.h>
#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace tma {

class HtcsSocketImpl
    : public util::IntrusiveListBaseNode<HtcsSocketImpl, HtcsManagerImpl>
{
public:
    explicit HtcsSocketImpl(HtcsManagerImpl* parent, int32_t descriptor) NN_NOEXCEPT;
    ~HtcsSocketImpl() NN_NOEXCEPT;
    nn::Result Close(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult) NN_NOEXCEPT;
    nn::Result Connect(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
    nn::Result Bind(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
    nn::Result Listen(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t backlogCount) NN_NOEXCEPT;
    nn::Result Accept(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress) NN_NOEXCEPT;
    nn::Result Recv(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
    nn::Result Send(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
    nn::Result Shutdown(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t how) NN_NOEXCEPT;
    nn::Result Fcntl(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t command, std::int32_t value) NN_NOEXCEPT;

    nn::Result AcceptStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle ) NN_NOEXCEPT;
    nn::Result AcceptResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress, uint32_t TaskId ) NN_NOEXCEPT;

    nn::Result RecvStart( nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, int64_t Amount, int32_t flags ) NN_NOEXCEPT;
    nn::Result RecvLargeStart ( nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, int32_t unalignedRecvSizeStart, int32_t unalignedRecvSizeEnd,
        int64_t alignedSize, nn::sf::NativeHandle alignedMemoryHandle, int32_t flags );
    nn::Result RecvResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::uint32_t TaskId) NN_NOEXCEPT;

    nn::Result SendStart( nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
    nn::Result SendResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, std::uint32_t TaskId) NN_NOEXCEPT;
    nn::Result SendLargeStart( nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle,
            const nn::sf::InBuffer& unalignedStart,  const nn::sf::InBuffer& unalignedEnd, nn::sf::NativeHandle alignedMemoryHandle, int64_t alignedSendSize, int32_t flags ) NN_NOEXCEPT;

    void CancelWait() NN_NOEXCEPT;
private:
    sf::SharedPointer<HtcsManagerImpl> m_Parent;
    std::atomic<int32_t> m_Descriptor;
};

}}
