﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//Need these for the DirectoryEntry definitions
#include <nn/fs/fs_Directory.h>
#include <nn/fs/fs_FileSystem.h>

#include "..\tmipc\tmipc_packet.h"
#include "..\tmipc\tmipc_task.h"

//==============================================================================
namespace tma { namespace hio {
//==============================================================================

typedef uint64_t TMA_HOSTIO_DIRECTORY_HANDLE;
#define INVALID_HOSTIO_DIRECTORY_HANDLE (uint64_t)-1

class HostDirectoryIOTask : public tmipc::Task
{
public:
        explicit        HostDirectoryIOTask ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
                       ~HostDirectoryIOTask ();

        // Results API
        TMA_HOSTIO_DIRECTORY_HANDLE GetHandle    ( void );
        s32             GetResult           ( void );
        s32             GetPriorityResult   ( void );
        bool            GetExistsResult     ( void );
        s64             GetCountResult      ( void );

protected:
        TMA_HOSTIO_DIRECTORY_HANDLE     m_Handle;
        int64_t                         m_OperationValue;
        s32                             m_Result;

        // This prepares a common packet for sending, given the passed code.
        tmipc::Packet*  PreparePacket       ( s32 TaskType );
};

//==============================================================================

class HostDirectoryIOExistsTask : public HostDirectoryIOTask
{
public:
        explicit        HostDirectoryIOExistsTask       ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
        virtual void    OnRecvPacket                    ( tmipc::Packet*    pPacket );
        virtual void    OnInitiate                      ( tmipc::Packet*    pPacket );
        virtual void    OnSendPacket                    ( tmipc::Packet*    pPacket );
        void            Exists                          ( const char*       pFullPath );
};

//==============================================================================

class HostDirectoryIOOpenTask : public HostDirectoryIOTask
{
public:
        explicit        HostDirectoryIOOpenTask         ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
        virtual void    OnRecvPacket                    ( tmipc::Packet*    pPacket );
        virtual void    OnInitiate                      ( tmipc::Packet*    pPacket );
        virtual void    OnSendPacket                    ( tmipc::Packet*    pPacket );
        void            Open                            ( TMA_HOSTIO_DIRECTORY_HANDLE*  pHandle,
                                                          const char*                   pFullPath,
                                                          int32_t                       OpenMode );
};

//==============================================================================

class HostDirectoryIOGetEntryCountTask : public HostDirectoryIOTask
{
public:
        explicit        HostDirectoryIOGetEntryCountTask( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
        virtual void    OnRecvPacket                    ( tmipc::Packet*    pPacket );
        virtual void    OnInitiate                      ( tmipc::Packet*    pPacket );
        virtual void    OnSendPacket                    ( tmipc::Packet*    pPacket );
        void            GetEntryCount                   ( void );
};

//==============================================================================

class HostDirectoryIOReadTask : public HostDirectoryIOTask
{
public:
    explicit        HostDirectoryIOReadTask ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
                   ~HostDirectoryIOReadTask ();

virtual void        OnRecvPacket            ( tmipc::Packet*    pPacket );
virtual void        OnInitiate              ( tmipc::Packet*    pPacket );
virtual void        OnSendPacket            ( tmipc::Packet*    pPacket );

    void            Read                    ( int64_t*                      pBytesRead,
                                              nn::fs::DirectoryEntry        pEntries[],
                                              int64_t                       numEntries );

private:
    void            HandleFSPacketEntry     ( tmipc::Packet*    pPacket );

    int32_t*        m_pBytesRead32;
    int64_t*        m_pBytesRead;
    int64_t         m_NumberOfEntriesToRead;
    char*           m_pReadToAddr;
    bool            m_FSType;       //Set to TRUE if this is the fs type of directory entry, FALSE if not (ie., fs0).
};

//==============================================================================

class HostDirectoryIOCloseTask : public HostDirectoryIOTask
{
public:
        explicit        HostDirectoryIOCloseTask        ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
        virtual void    OnRecvPacket                    ( tmipc::Packet*    pPacket );
        virtual void    OnInitiate                      ( tmipc::Packet*    pPacket );
        virtual void    OnSendPacket                    ( tmipc::Packet*    pPacket );
        void            Close                           ( void );

};

//==============================================================================

class HostDirectoryIOSetPriorityTask : public HostDirectoryIOTask
{
public:
        explicit        HostDirectoryIOSetPriorityTask  ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
        virtual void    OnRecvPacket                    ( tmipc::Packet*    pPacket );
        virtual void    OnInitiate                      ( tmipc::Packet*    pPacket );
        virtual void    OnSendPacket                    ( tmipc::Packet*    pPacket );
        void            SetPriority                     ( s32                           Priority );
};

//==============================================================================

class HostDirectoryIOGetPriorityTask : public HostDirectoryIOTask
{
public:
        explicit        HostDirectoryIOGetPriorityTask  ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
        virtual void    OnRecvPacket                    ( tmipc::Packet*    pPacket );
        virtual void    OnInitiate                      ( tmipc::Packet*    pPacket );
        virtual void    OnSendPacket                    ( tmipc::Packet*    pPacket );
        void            GetPriority                     ( void );
};

//==============================================================================

class HostDirectoryIOCreateTask : public HostDirectoryIOTask
{
public:
        explicit        HostDirectoryIOCreateTask       ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
        virtual void    OnRecvPacket                    ( tmipc::Packet*    pPacket );
        virtual void    OnInitiate                      ( tmipc::Packet*    pPacket );
        virtual void    OnSendPacket                    ( tmipc::Packet*    pPacket );
        void            Create                          ( const char*       pFullPath );
};

//==============================================================================

class HostDirectoryIODeleteTask : public HostDirectoryIOTask
{
public:
        explicit        HostDirectoryIODeleteTask       ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
        virtual void    OnRecvPacket                    ( tmipc::Packet*    pPacket );
        virtual void    OnInitiate                      ( tmipc::Packet*    pPacket );
        virtual void    OnSendPacket                    ( tmipc::Packet*    pPacket );
        void            Delete                          ( const char*                   pFullPath,
                                                          u8                            Recursively );
};

//==============================================================================

class HostDirectoryIORenameTask : public HostDirectoryIOTask
{
public:
        explicit        HostDirectoryIORenameTask       ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );
        virtual void    OnRecvPacket                    ( tmipc::Packet*    pPacket );
        virtual void    OnInitiate                      ( tmipc::Packet*    pPacket );
        virtual void    OnSendPacket                    ( tmipc::Packet*    pPacket );
        void            Rename                          ( const char*                   pFrom,
                                                          const char*                   pTo );
};

//==============================================================================
}}
//==============================================================================
