﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmagent.h"
#include "..\tma\tma_MQ.h"
#include "..\tmipc\tmipc_task.h"
#include "..\tmipc\tmipc_packet.h"
#include "..\tmipc\tmipc_service.h"
#include "hio_directory_task.h"
#undef CreateDirectory

//==============================================================================
namespace tma { namespace hio {
//==============================================================================

class AgentHostDirectoryIOService : public tmipc::Service
{
private:

public:
                    AgentHostDirectoryIOService     ();
                    ~AgentHostDirectoryIOService    ();

    void                                Init                ( void );
    void                                Kill                ( void );

    template <class T> T*               CreateTask          ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );

    HostDirectoryIOExistsTask*          DirectoryExists     ( const char*                   pFullPath );

    HostDirectoryIOOpenTask*            OpenDirectory       ( TMA_HOSTIO_DIRECTORY_HANDLE*  pHandle,
                                                              const char*                   pPath,
                                                              int32_t                       OpenMode );

    HostDirectoryIOGetEntryCountTask*   GetDirectoryCount   ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );

    HostDirectoryIOReadTask*            ReadDirectory       ( int64_t*                      pOut,
                                                              TMA_HOSTIO_DIRECTORY_HANDLE   Handle,
                                                              nn::fs::DirectoryEntry        pEntries[],
                                                              int64_t                       NumEntries );

    HostDirectoryIOCloseTask*           CloseDirectory      ( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );


    HostDirectoryIOSetPriorityTask*     SetDirectoryPriority( TMA_HOSTIO_DIRECTORY_HANDLE   Handle,
                                                              s32                           Priority );

    HostDirectoryIOGetPriorityTask*     GetDirectoryPriority( TMA_HOSTIO_DIRECTORY_HANDLE   Handle );

    HostDirectoryIOCreateTask*          CreateDirectory     ( const char*                   pFullPath );

    HostDirectoryIODeleteTask*          DeleteDirectory     ( const char*                   pFullPath,
                                                              int32_t                       Recursively );

    HostDirectoryIORenameTask*          RenameDirectory     ( const char*                   pFromPath,
                                                              const char*                   pToPath );

protected:
virtual tmipc::Task*        OnNewTask           ( tmipc::Packet*                pPacket );

};

//==============================================================================
// Global Directory IO service object.
AgentHostDirectoryIOService& GetHostDirectoryIOService( void );

//==============================================================================
}}
//==============================================================================
