﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/tma/sf/tma_IFileManager.h>

namespace nn { namespace tma {

class FileManagerImpl
{
public:
    nn::Result OpenFile(nn::sf::Out<nn::sf::SharedPointer<nn::tma::IFileAccessor>> handle, const nn::tma::Path& pPath, std::uint32_t openMode) NN_NOEXCEPT;
    nn::Result FileExists(nn::sf::Out<bool> pExists, const nn::tma::Path& pPath) NN_NOEXCEPT;
    nn::Result DeleteFile(const nn::tma::Path& pPath) NN_NOEXCEPT;
    nn::Result RenameFile(const nn::tma::Path& pFromName, const nn::tma::Path& pToName) NN_NOEXCEPT;
    nn::Result GetIOType(nn::sf::Out<std::int32_t> pType, const nn::tma::Path& pPath) NN_NOEXCEPT;
    nn::Result OpenDirectory(nn::sf::Out<nn::sf::SharedPointer<nn::tma::IDirectoryAccessor>> pHandle, const nn::tma::Path& pathName, std::int32_t openMode) NN_NOEXCEPT;
    nn::Result DirectoryExists(nn::sf::Out<bool> pOut, const nn::tma::Path& pathName) NN_NOEXCEPT;
    nn::Result CreateDirectory(const nn::tma::Path& pathName) NN_NOEXCEPT;
    nn::Result DeleteDirectory(const nn::tma::Path& pathName, bool recursively) NN_NOEXCEPT;
    nn::Result RenameDirectory(const nn::tma::Path& fromName, const nn::tma::Path& toName) NN_NOEXCEPT;
    nn::Result CreateFile(const nn::tma::Path& pPath, std::int64_t size) NN_NOEXCEPT;
    nn::Result GetFileTimeStamp( nn::sf::Out<std::uint64_t> pCreateTime, nn::sf::Out<std::uint64_t> pAccessTime, nn::sf::Out<std::uint64_t> pModifyTime, const nn::tma::Path& pathName );
};

}}
