﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// このファイルはユーザ定義

#include "hio_DirectoryAccessorImpl.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>
#include "hio_api.h"

namespace nn { namespace tma {

DirectoryAccessorImpl::DirectoryAccessorImpl(directory_io::TMA_DIR_HANDLE handle) NN_NOEXCEPT
{
    m_Handle = handle;
}

DirectoryAccessorImpl::~DirectoryAccessorImpl() NN_NOEXCEPT
{
    directory_io::CloseDirectory( m_Handle );
}

nn::Result DirectoryAccessorImpl::GetEntryCount(nn::sf::Out<std::int64_t> pCount) NN_NOEXCEPT
{
    int64_t count;
    NN_RESULT_DO( directory_io::GetEntryCount( &count, m_Handle ) );
    pCount.Set( count );
    NN_RESULT_SUCCESS;
}

nn::Result DirectoryAccessorImpl::ReadDirectory(nn::sf::Out<std::int64_t> pOut, const nn::sf::OutArray<nn::fs::DirectoryEntry>& pEntries) NN_NOEXCEPT
{
    int64_t out;
    NN_RESULT_DO( directory_io::ReadDirectory( &out, pEntries.GetData(), m_Handle, pEntries.GetLength() ) );
    pOut.Set( out );
    NN_RESULT_SUCCESS;
}

nn::Result DirectoryAccessorImpl::SetPriorityForDirectory(std::int32_t priority) NN_NOEXCEPT
{
    return directory_io::SetPriorityForDirectory( m_Handle, priority );
}

nn::Result DirectoryAccessorImpl::GetPriorityForDirectory(nn::sf::Out<std::int32_t> pOut) NN_NOEXCEPT
{
    int32_t out;
    NN_RESULT_DO( directory_io::GetPriorityForDirectory( &out, m_Handle ) );
    pOut.Set( out );
    NN_RESULT_SUCCESS;
}


}}
