﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "..\tmagent.h"
#include "..\tmipc\tmipc_result.h"
#include "hid_opcodes.h"
#include "hid_Service.h"
#include "hid_Task.h"
#include "hid_structures.h"

//==============================================================================
namespace tma { namespace hid {
//==============================================================================

ControllerReadTask::ControllerReadTask()
{
    m_TaskType = tmipc::TaskType_HidControllerRead;
}

//==============================================================================

ControllerReadTask::~ControllerReadTask()
{
}

//==============================================================================

void ControllerReadTask::OnInitiate( tmipc::Packet* pPacket )
{
    s32 Opcode;
    s32 Result = tmipc::TMIPC_RESULT_OK;

    Result = pPacket->ReadS32( Opcode );

    if( Result == tmipc::TMIPC_RESULT_OK )
    {
        switch( Opcode )
        {
            case tma::hid::TMA_OP_GAMEPAD_STATE:
            {
                s32 nControllers = 0;
                Result = pPacket->ReadS32( nControllers );

                if( Result == tmipc::TMIPC_RESULT_OK )
                {
                    for( s32 i = 0; i < nControllers; i++ )
                    {
                        s32 StructSize = 0;
                        u8* pBuffer = NULL;

                        Result = pPacket->ReadS32( StructSize );

                        if( Result == tmipc::TMIPC_RESULT_OK )
                        {
                            void* pMem = s_Allocate( sizeof( u8 ) * StructSize );
                            pBuffer = new (pMem) u8[StructSize];
                            Result = pPacket->ReadData( pBuffer, StructSize );
                        }

                        if( Result == tmipc::TMIPC_RESULT_OK )
                        {
                            controller_data* pControllerData = (controller_data*)pBuffer;
                            ((AgentControllerService*)GetService())->UpdateControllerState(pControllerData );
                        }
                        s_Deallocate( pBuffer, sizeof( u8 ) * StructSize );
                    }
                }
            }
            break;

            case tma::hid::TMA_OP_GAMEPAD_BATTERY:
                {
                    // TODO - Handle battery messages here.
//                     s32 iController = 0;
//                     s32 BatteryLevel = 0;
//                     pPacket->ReadS32( iController );
//                     pPacket->ReadS32( BatteryLevel );
//                     NN_SDK_LOG( "Received a gamepad battery message.\n" );
                }
                break;

            case tma::hid::TMA_OP_GAMEPAD_CONNECT:
                {
                    // TODO - Handle gamepad connect messages here.
//                     s32 iController = 0;
//                     pPacket->ReadS32( iController );
//                     NN_SDK_LOG( "Received a gamepad connect message.\n" );
                }
                break;

            case tma::hid::TMA_OP_GAMEPAD_DISCONNECT:
                {
                    // TODO - Handle gamepad disconnect messages here.
//                    s32 iController = 0;
//                    pPacket->ReadS32( iController );
//                    NN_SDK_LOG( "Received a gamepad disconnect message.\n" );
                }
                break;

            case tma::hid::TMA_OP_KEYBOARD:
            {
                s32 Character;
                Result = pPacket->ReadS32( Character );

                if( Result == tmipc::TMIPC_RESULT_OK )
                {
                    ((AgentControllerService*)GetService())->UpdateKeyboardInput( Character );
                }
            }
            break;

            default: break;
        }
    }

    Complete();
}

//==============================================================================

void ControllerReadTask::OnRecvPacket( tmipc::Packet* pPacket )
{
    // TODO - Handle Packet
    (void)pPacket;
}

//==============================================================================

void ControllerReadTask::OnSendPacket( tmipc::Packet* pPacket )
{
    // TODO - Handle Packet
    (void)pPacket;
}

//==============================================================================
}}
//==============================================================================
