﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include "..\tmipc\tmipc_node_tics.h"

//==============================================================================

namespace nn { namespace tma {

//==============================================================================

namespace bridge_api {

      void              Initialize          ( tmipc::NodeTICS* AgentNode );
      void              Finalize            ( );

      nn::Result        SetSleepStatus      ( bool bSleep );
      nn::Result        SetCradleAttached   ( bool bAttached );
      nn::Result        GetBridgeIpAddress  ( char *ipAddress, int ipAddressLen );
      nn::Result        GetBridgeSubnetMask ( char *subnetMask, int subnetMaskLen );
      nn::Result        GetBridgeMacAddress ( char *macAddress, int macAddressLen );
      nn::Result        GetBridgePort       ( char *port, int portLen );

      nn::Result        ConfigSectionAttrGet( const char* sectionName, const char *attrName, char *attrValue, int attrValueLen );
} // namespace bridge_api

}} // namespace
//==============================================================================
