﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
//  INCLUDES
//==============================================================================

//#define CTRL_PERFORMANCE

#include "..\tmagent.h"
#include "..\tmipc\tmipc_service.h"
#include "env_Task.h"

//==============================================================================
namespace tma { namespace env {
//==============================================================================

class AgentEnvService : public tmipc::Service
{
public:
                            AgentEnvService         ();
                           ~AgentEnvService         ();

            void            Init                    ();
            void            Kill                    ();

            s32             GetEnvironmentVariable  ( int32_t*          pLength,
                                                      char*             pBuffer,
                                                      int32_t           bufferLength,
                                                      const char*       pName ) NN_NOEXCEPT;

            s32             GetEnvironmentVariableLength  ( int32_t*          pLength,
                                                      const char*       pName ) NN_NOEXCEPT;

protected:
    virtual tmipc::Task*    OnNewTask               ( tmipc::Packet*    pPacket );
};

//==============================================================================
// Global Env service object.
AgentEnvService& GetEnvService( void );

//==============================================================================
}}
//==============================================================================
