﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// WARNING: THERE ARE TWO COPIES OF THIS FILE WHICH MUST STAY IN SYNC

#pragma once

#include "dbg_CommandArgs.h"
#include "../tma/tma_Mutex.h"

//==============================================================================
namespace tma { namespace dbg {
//==============================================================================

class Process;

//==============================================================================

class BreakpointMgr
{
protected:
    enum
    {
        SYS_BREAKPOINTS = 8,
        USR_BREAKPOINTS = 256,
        MAX_BREAKPOINTS = SYS_BREAKPOINTS + USR_BREAKPOINTS,
        MAX_WATCH_REGS  = 16
    };

    u64         m_ContextControlReg;
    u64         m_ContextValueReg;
    s32         m_ContextReg;
    u32         m_WatchRegsMask;
    s32         m_NumWatchRegs;

    s32         m_nActive;
    s32         m_MaxActive;

    break_point m_Breakpoints[ MAX_BREAKPOINTS ] = { 0 };
    Process*    m_pParent;
    //tma::Mutex  m_SBPMutex;             // Mutex for SetBreakpoint

public:
                BreakpointMgr           ();

    void        Init                    ( Process* Parent );
    void        Kill                    ();

    void        Reset                   ();
    void        DumpBreakpoints         ();

    void        GetBreakpoint           ( break_point&  BP ); // Address is only input field
    void        SetBreakpoint           ( break_point&  BP );

    bool        IsBreakpoint            ( u32 Instruction );
    void        DisableBreakpoint       ( break_point&  BP );
    void        EnableBreakpoint        ( break_point&  BP);

    void        ClearBreakpoints        ( bp_state      State, u64 ThreadId = 0 );
    void        PatchReadMemory         ( void* pBuffer, u64 address, u32 nBytes );
};

//==============================================================================
}} // namespace
//==============================================================================
