﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmipc\tmipc_packet.h"
#include "..\tmipc\tmipc_task.h"
#include "..\tm_result.h"
#include "..\tma\tma_Thread.h"
#include "coredump_opcodes.h"

//==============================================================================
namespace tma { namespace coredump {
//==============================================================================

class CoredumpTask : public tmipc::Task
{
public:
    explicit        CoredumpTask        ( Service*          pOwner );
                    ~CoredumpTask       ();

virtual void        OnInitiate          ( tmipc::Packet*    pPacket );
virtual void        OnRecvPacket        ( tmipc::Packet*    pPacket );
virtual void        OnSendPacket        ( tmipc::Packet*    pPacket );

protected:
    Thread                  m_WorkThread;
    nn::os::LightEventType  m_Event;
    bool                    m_Cancel;
    bool                    m_Done;
    u64                     m_ProcessId;
    char*                   m_pTTYData;
    u32                     m_SizeOfTTYData;
    Service*                m_pOwner;

        void        Notify              ( notification      Type,
                                          int32_t           Data );

        void        Finalize            ();

static void*        WorkThread          ( void*             pArgs );

};

//==============================================================================
}}
//==============================================================================
