﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../tmipc/tmipc_defines.h"
#if ENABLE_BENCHMARK_TESTING

#include "../tmipc/tmipc_packet.h"
#include "../tmipc/tmipc_service.h"

//==============================================================================
namespace tma { namespace benchmark {
//==============================================================================

class BenchmarkReportService : public tmipc::Service
{
private:

    // Magic numbers.
    enum
    {
        NumberOfPings = 1000
    };

    // These two parallel arrays keep track of the time it takes between
    // receiving a "benchmark" packet and sending the packet back.
    // To be clear:
    // - The timer starts when "a benchmark Packet" is received.
    // - The timer stops when "a benchmark response Packet" is about to be sent.
    // The Packet's "service id" and "sequence numbers" have to match for a
    // valid timing.
    static s64 m_PingTimesStart[NumberOfPings];
    static s64 m_PingTimesFinish[NumberOfPings];

    // Indexes the m_[Start|Finsh]PingTimes arrays.
    static s32 m_PingTimesIndex;

    // Current Packet task id.  Start/Finish need to match to be considered
    // "valid".
    static u32 m_PacketTaskId;

    // Recorded BenchmarkService ServiceId.
    static u32 m_BenchmarkServiceId;

private:

virtual tmipc::Task* OnNewTask( tmipc::Packet* pPacket );

    // Called when a packet was received.
static void OnPacketReceivedCallback( const tmipc::Packet& Packet );

    // Called when a packet is about to be sent.
static void OnPacketSendCallback( const tmipc::Packet& Packet );

public:
    BenchmarkReportService();
    ~BenchmarkReportService();

    void Init();
    void Kill();

    // Start recording Packet received/send timing information.
    void Start();
    // Stop recording Packet received/send timing information.
    void Stop();
    // Generate a report and add it to the given packet.  This is only safe to
    // call outside of the Start()/Stop() period.
    void GenerateReport( tmipc::Packet& Packet );
};

BenchmarkReportService& GetBenchmarkReportService( void );

//==============================================================================
}}
//==============================================================================

#endif // ENABLE_BENCHMARK_TESTING
