﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/timesrv/detail/service/timesrv_SteadyClockServer.h>
#include <nn/timesrv/detail/core/timesrv_SteadyClockCore.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace service
{

using ::nn::time::SteadyClockTimePoint;
using ::nn::timesrv::detail::core::SteadyClockCore;

SteadyClockServer::SteadyClockServer(SteadyClockCore* pSteadyClockCore, bool isAdministrator) NN_NOEXCEPT
    : m_pSteadyClockCore(pSteadyClockCore),
      m_IsAdministrator(isAdministrator)
{
}

SteadyClockServer::~SteadyClockServer() NN_NOEXCEPT
{
}

Result SteadyClockServer::GetCurrentTimePoint(nn::sf::Out<SteadyClockTimePoint> outSteadyClockTimePoint) NN_NOEXCEPT
{
    SteadyClockTimePoint steadyClockTimePoint;
    NN_RESULT_DO( m_pSteadyClockCore->GetCurrentTimePoint(&steadyClockTimePoint) );

    outSteadyClockTimePoint.Set(steadyClockTimePoint);
    NN_RESULT_SUCCESS;
}

Result SteadyClockServer::GetTestOffset(nn::sf::Out<nn::TimeSpanType> outTestOffset) NN_NOEXCEPT
{
    outTestOffset.Set(m_pSteadyClockCore->GetTestOffset());
    NN_RESULT_SUCCESS;
}

Result SteadyClockServer::SetTestOffset(const nn::TimeSpanType& testOffset) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(m_IsAdministrator, nn::time::ResultNoCapability());
    m_pSteadyClockCore->SetTestOffset(testOffset);
    NN_RESULT_SUCCESS;
}

Result SteadyClockServer::GetRtcValue(nn::sf::Out<int64_t> outValue) NN_NOEXCEPT
{
    int64_t rtcSeconds;
    NN_RESULT_DO( m_pSteadyClockCore->GetRtcSeconds(&rtcSeconds) );

    outValue.Set(rtcSeconds);

    NN_RESULT_SUCCESS;
}

Result SteadyClockServer::IsRtcResetDetected(nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    outValue.Set(m_pSteadyClockCore->IsRtcResetDetected());

    NN_RESULT_SUCCESS;
}

Result SteadyClockServer::GetSetupResutltValue(nn::sf::Out<uint32_t> outValue) NN_NOEXCEPT
{
    outValue.Set(m_pSteadyClockCore->GetSetupResultValue());

    NN_RESULT_SUCCESS;
}

Result SteadyClockServer::GetInternalOffset(nn::sf::Out<nn::TimeSpanType> outInternalOffset) NN_NOEXCEPT
{
    nn::TimeSpan internalOffset;
    outInternalOffset.Set(m_pSteadyClockCore->GetInternalOffset());

    NN_RESULT_SUCCESS;
}

}
}
}
}
